/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config.plugins.util;

import java.io.IOException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import org.apache.logging.log4j.core.config.plugins.util.PluginRegistry;
import org.apache.logging.log4j.core.config.plugins.util.ResolverUtil;
import org.apache.logging.log4j.core.config.plugins.util.ResolverUtilTest;
import org.apache.logging.log4j.junit.CleanFolders;
import org.apache.logging.log4j.junit.URLStreamHandlerFactoryRule;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class ResolverUtilCustomProtocolTest {
    @Rule
    public URLStreamHandlerFactoryRule rule = new URLStreamHandlerFactoryRule(new NoopURLStreamHandlerFactory());
    @Rule
    public RuleChain chain = RuleChain.outerRule((TestRule)new CleanFolders("target/testpluginsutil"));

    @Test
    public void testExtractPathFromVfsEarJarWindowsUrl() throws Exception {
        URL url = new URL("vfs:/C:/jboss/jboss-eap-6.4/standalone/deployments/com.xxx.yyy.application-ear.ear/lib/com.xxx.yyy.logging.jar/com/xxx/yyy/logging/config/");
        String expected = "/C:/jboss/jboss-eap-6.4/standalone/deployments/com.xxx.yyy.application-ear.ear/lib/com.xxx.yyy.logging.jar/com/xxx/yyy/logging/config/";
        Assert.assertEquals((Object)"/C:/jboss/jboss-eap-6.4/standalone/deployments/com.xxx.yyy.application-ear.ear/lib/com.xxx.yyy.logging.jar/com/xxx/yyy/logging/config/", (Object)new ResolverUtil().extractPath(url));
    }

    @Test
    public void testExtractPathFromVfsWarClassesWindowsUrl() throws Exception {
        URL url = new URL("vfs:/C:/jboss/jboss-eap-6.4/standalone/deployments/test-log4j2-web-standalone.war/WEB-INF/classes/org/hypik/test/jboss/eap7/logging/config/");
        String expected = "/C:/jboss/jboss-eap-6.4/standalone/deployments/test-log4j2-web-standalone.war/WEB-INF/classes/org/hypik/test/jboss/eap7/logging/config/";
        Assert.assertEquals((Object)"/C:/jboss/jboss-eap-6.4/standalone/deployments/test-log4j2-web-standalone.war/WEB-INF/classes/org/hypik/test/jboss/eap7/logging/config/", (Object)new ResolverUtil().extractPath(url));
    }

    @Test
    public void testExtractPathFromVfsWarClassesLinuxUrl() throws Exception {
        URL url = new URL("vfs:/content/mycustomweb.war/WEB-INF/classes/org/hypik/test/jboss/log4j2/logging/pluginweb/");
        String expected = "/content/mycustomweb.war/WEB-INF/classes/org/hypik/test/jboss/log4j2/logging/pluginweb/";
        Assert.assertEquals((Object)"/content/mycustomweb.war/WEB-INF/classes/org/hypik/test/jboss/log4j2/logging/pluginweb/", (Object)new ResolverUtil().extractPath(url));
    }

    @Test
    public void testExtractPathFromVfszipUrl() throws Exception {
        URL url = new URL("vfszip:/home2/jboss-5.0.1.CR2/jboss-as/server/ais/ais-deploy/myear.ear/mywar.war/WEB-INF/some.xsd");
        String expected = "/home2/jboss-5.0.1.CR2/jboss-as/server/ais/ais-deploy/myear.ear/mywar.war/WEB-INF/some.xsd";
        Assert.assertEquals((Object)"/home2/jboss-5.0.1.CR2/jboss-as/server/ais/ais-deploy/myear.ear/mywar.war/WEB-INF/some.xsd", (Object)new ResolverUtil().extractPath(url));
    }

    @Test
    public void testExtractPathFromVfsEarJarLinuxUrl() throws Exception {
        URL url = new URL("vfs:/content/test-log4k2-ear.ear/lib/test-log4j2-jar-plugins.jar/org/hypik/test/jboss/log4j2/pluginjar/");
        String expected = "/content/test-log4k2-ear.ear/lib/test-log4j2-jar-plugins.jar/org/hypik/test/jboss/log4j2/pluginjar/";
        Assert.assertEquals((Object)"/content/test-log4k2-ear.ear/lib/test-log4j2-jar-plugins.jar/org/hypik/test/jboss/log4j2/pluginjar/", (Object)new ResolverUtil().extractPath(url));
    }

    @Test
    public void testExtractPathFromVfszipUrlWithPlusCharacters() throws Exception {
        URL url = new URL("vfszip:/path+with+plus/file+name+with+plus.xml");
        String expected = "/path+with+plus/file+name+with+plus.xml";
        Assert.assertEquals((Object)"/path+with+plus/file+name+with+plus.xml", (Object)new ResolverUtil().extractPath(url));
    }

    @Test
    public void testExtractPathFromVfsUrlWithPlusCharacters() throws Exception {
        URL url = new URL("vfs:/path+with+plus/file+name+with+plus.xml");
        String expected = "/path+with+plus/file+name+with+plus.xml";
        Assert.assertEquals((Object)"/path+with+plus/file+name+with+plus.xml", (Object)new ResolverUtil().extractPath(url));
    }

    @Test
    public void testExtractPathFromResourceBundleUrl() throws Exception {
        URL url = new URL("bundleresource:/some/path/some/file.properties");
        String expected = "/some/path/some/file.properties";
        Assert.assertEquals((Object)"/some/path/some/file.properties", (Object)new ResolverUtil().extractPath(url));
    }

    @Test
    public void testExtractPathFromResourceBundleUrlWithPlusCharacters() throws Exception {
        URL url = new URL("bundleresource:/some+path/some+file.properties");
        String expected = "/some+path/some+file.properties";
        Assert.assertEquals((Object)"/some+path/some+file.properties", (Object)new ResolverUtil().extractPath(url));
    }

    @Test
    public void testFindInPackageFromVfsDirectoryURL() throws Exception {
        try (URLClassLoader cl = ResolverUtilTest.compileAndCreateClassLoader("3");){
            ResolverUtil resolverUtil = new ResolverUtil();
            resolverUtil.setClassLoader((ClassLoader)new SingleURLClassLoader(new URL("vfs:/target/testpluginsutil/resolverutil3/customplugin3/"), (ClassLoader)cl));
            resolverUtil.findInPackage((ResolverUtil.Test)new PluginRegistry.PluginTest(), "customplugin3");
            Assert.assertEquals((String)"Class not found in packages", (long)1L, (long)resolverUtil.getClasses().size());
            Assert.assertEquals((String)"Unexpected class resolved", cl.loadClass("customplugin3.FixedString3Layout"), resolverUtil.getClasses().iterator().next());
        }
    }

    @Test
    public void testFindInPackageFromVfsJarURL() throws Exception {
        try (URLClassLoader cl = ResolverUtilTest.compileJarAndCreateClassLoader("4");){
            ResolverUtil resolverUtil = new ResolverUtil();
            resolverUtil.setClassLoader((ClassLoader)new SingleURLClassLoader(new URL("vfs:/target/testpluginsutil/resolverutil4/customplugin4.jar/customplugin4/"), (ClassLoader)cl));
            resolverUtil.findInPackage((ResolverUtil.Test)new PluginRegistry.PluginTest(), "customplugin4");
            Assert.assertEquals((String)"Class not found in packages", (long)1L, (long)resolverUtil.getClasses().size());
            Assert.assertEquals((String)"Unexpected class resolved", cl.loadClass("customplugin4.FixedString4Layout"), resolverUtil.getClasses().iterator().next());
        }
    }

    static class SingleURLClassLoader
    extends ClassLoader {
        private final URL url;

        public SingleURLClassLoader(URL url) {
            this.url = url;
        }

        public SingleURLClassLoader(URL url, ClassLoader parent) {
            super(parent);
            this.url = url;
        }

        @Override
        protected URL findResource(String name) {
            return this.url;
        }

        @Override
        public URL getResource(String name) {
            return this.findResource(name);
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            return this.findResources(name);
        }

        @Override
        protected Enumeration<URL> findResources(String name) throws IOException {
            return Collections.enumeration(Arrays.asList(this.findResource(name)));
        }
    }

    static class NoopURLStreamHandlerFactory
    implements URLStreamHandlerFactory {
        NoopURLStreamHandlerFactory() {
        }

        @Override
        public URLStreamHandler createURLStreamHandler(String protocol) {
            return new URLStreamHandler(){

                @Override
                protected URLConnection openConnection(URL url) {
                    return this.open(url, null);
                }

                private URLConnection open(URL url, Proxy proxy) {
                    return new URLConnection(url){

                        @Override
                        public void connect() throws IOException {
                        }
                    };
                }

                @Override
                protected URLConnection openConnection(URL url, Proxy proxy) {
                    return this.open(url, proxy);
                }

                @Override
                protected int getDefaultPort() {
                    return 1;
                }
            };
        }
    }
}

