/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling;

import org.apache.logging.log4j.core.appender.rolling.FileSize;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;

public class FileSizeTest {
    private static final long EXPECTED = 10240L;

    @Test
    public void testFileSize() {
        long value = FileSize.parse((String)"10KB", (long)0L);
        Assertions.assertEquals((long)10240L, (long)value, (String)("unexpected value " + value));
        value = FileSize.parse((String)"10 KB", (long)0L);
        Assertions.assertEquals((long)10240L, (long)value, (String)("unexpected value " + value));
    }

    @ParameterizedTest(name="[{index}] \"{0}\" -> {1}")
    @CsvSource(delimiter=58, value={"10:10", "10KB:10240", "10 KB:10240", "10 kb:10240", " 10 kb :10240", "0.1 MB:104857", "1 MB:1048576", "10 MB:10485760", "10.45 MB:10957619", "10.75 MB:11272192", "1,000 KB:1024000", "1 GB:1073741824", "0.51 GB:547608330"})
    void testValidFileSizes(String expr, long expected) {
        Assertions.assertEquals((long)expected, (long)FileSize.parse((String)expr, (long)0L));
    }
}

