/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.lookup;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.lookup.MarkerLookup;
import org.apache.logging.log4j.core.lookup.StrLookup;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.SimpleMessage;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MarkerLookupTest {
    private static final String ABSENT_MARKER_NAME = "NONE";
    private final String markerName = "MarkerLookupTest";
    private final StrLookup strLookup = new MarkerLookup();

    @Test
    public void testLookupEventExistant() {
        Marker marker = MarkerManager.getMarker((String)"MarkerLookupTest");
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName(this.getClass().getName()).setMarker(marker).setLoggerFqcn("org.apache.logging.log4j.core.Logger").setLevel(Level.INFO).setMessage((Message)new SimpleMessage("Hello, world!")).build();
        String value = this.strLookup.lookup((LogEvent)event, marker.getName());
        Assertions.assertEquals((Object)"MarkerLookupTest", (Object)value);
    }

    @Test
    public void testLookupEventNonExistant() {
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName(this.getClass().getName()).setLoggerFqcn("org.apache.logging.log4j.core.Logger").setLevel(Level.INFO).setMessage((Message)new SimpleMessage("Hello, world!")).build();
        String value = this.strLookup.lookup((LogEvent)event, ABSENT_MARKER_NAME);
        Assertions.assertNull((Object)value);
    }

    @Test
    public void testLookupEventNonExistantKey() {
        Marker marker = MarkerManager.getMarker((String)"MarkerLookupTest");
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName(this.getClass().getName()).setMarker(marker).setLoggerFqcn("org.apache.logging.log4j.core.Logger").setLevel(Level.INFO).setMessage((Message)new SimpleMessage("Hello, world!")).build();
        String value = this.strLookup.lookup((LogEvent)event, ABSENT_MARKER_NAME);
        Assertions.assertEquals((Object)"MarkerLookupTest", (Object)value);
    }

    @Test
    public void testLookupEventNullNonExistant() {
        String value = this.strLookup.lookup(null, ABSENT_MARKER_NAME);
        Assertions.assertNull((Object)value);
    }

    @Test
    public void testLookupExistant() {
        String value = this.strLookup.lookup(MarkerManager.getMarker((String)"MarkerLookupTest").getName());
        Assertions.assertEquals((Object)"MarkerLookupTest", (Object)value);
    }

    @Test
    public void testLookupNonExistant() {
        String value = this.strLookup.lookup(ABSENT_MARKER_NAME);
        Assertions.assertNull((Object)value);
    }
}

