/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.lookup;

import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.lookup.JndiExploit;
import org.apache.logging.log4j.core.lookup.JndiLookup;
import org.apache.logging.log4j.message.SimpleMessage;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.zapodot.junit.ldap.EmbeddedLdapRule;
import org.zapodot.junit.ldap.EmbeddedLdapRuleBuilder;

public class JndiRestrictedLookupTest {
    private static final String LDAP_URL = "ldap://127.0.0.1:";
    private static final String RESOURCE = "JndiExploit";
    private static final String TEST_STRING = "TestString";
    private static final String TEST_MESSAGE = "TestMessage";
    private static final String LEVEL = "TestLevel";
    private static final String DOMAIN_DSN = "dc=apache,dc=org";
    private static final String DOMAIN = "apache.org";
    @Rule
    public EmbeddedLdapRule embeddedLdapRule = EmbeddedLdapRuleBuilder.newInstance().usingDomainDsn("dc=apache,dc=org").importingLdifs(new String[]{"JndiRestrictedLookup.ldif"}).build();

    @BeforeClass
    public static void beforeClass() {
        System.setProperty("log4j2.allowedLdapClasses", Level.class.getName());
        System.setProperty("log4j2.allowedJndiProtocols", "dns");
    }

    @Test
    public void testBadUriLookup() throws Exception {
        int port = this.embeddedLdapRule.embeddedServerPort();
        Context context = this.embeddedLdapRule.context();
        context.bind("cn=JndiExploit,dc=apache,dc=org", (Object)new Fruit("Test Message"));
        JndiLookup lookup = new JndiLookup();
        String result = lookup.lookup(LDAP_URL + port + "/cn=" + RESOURCE + "," + DOMAIN_DSN + "?Type=A Type&Name=1100110&Char=!");
        if (result != null) {
            Assert.fail((String)"Lookup returned an object");
        }
    }

    @Test
    public void testReferenceLookup() throws Exception {
        int port = this.embeddedLdapRule.embeddedServerPort();
        Context context = this.embeddedLdapRule.context();
        context.bind("cn=JndiExploit,dc=apache,dc=org", (Object)new Fruit("Test Message"));
        JndiLookup lookup = new JndiLookup();
        String result = lookup.lookup(LDAP_URL + port + "/cn=" + RESOURCE + "," + DOMAIN_DSN);
        if (result != null) {
            Assert.fail((String)"Lookup returned an object");
        }
    }

    @Test
    public void testSerializableLookup() throws Exception {
        int port = this.embeddedLdapRule.embeddedServerPort();
        Context context = this.embeddedLdapRule.context();
        context.bind("cn=TestString,dc=apache,dc=org", (Object)"Test Message");
        JndiLookup lookup = new JndiLookup();
        String result = lookup.lookup(LDAP_URL + port + "/cn=" + TEST_STRING + "," + DOMAIN_DSN);
        if (result == null) {
            Assert.fail((String)"Lookup failed to return the test string");
        }
        Assert.assertEquals((String)"Incorrect message returned", (Object)"Test Message", (Object)result);
    }

    @Test
    public void testBadSerializableLookup() throws Exception {
        int port = this.embeddedLdapRule.embeddedServerPort();
        Context context = this.embeddedLdapRule.context();
        context.bind("cn=TestMessage,dc=apache,dc=org", (Object)new SimpleMessage("Test Message"));
        JndiLookup lookup = new JndiLookup();
        String result = lookup.lookup(LDAP_URL + port + "/cn=" + TEST_MESSAGE + "," + DOMAIN_DSN);
        if (result != null) {
            Assert.fail((String)"Lookup returned an object");
        }
    }

    @Test
    public void testSpecialSerializableLookup() throws Exception {
        int port = this.embeddedLdapRule.embeddedServerPort();
        Context context = this.embeddedLdapRule.context();
        context.bind("cn=TestLevel,dc=apache,dc=org", (Object)Level.ERROR);
        JndiLookup lookup = new JndiLookup();
        String result = lookup.lookup(LDAP_URL + port + "/cn=" + LEVEL + "," + DOMAIN_DSN);
        if (result == null) {
            Assert.fail((String)"Lookup failed to return the level");
        }
        Assert.assertEquals((String)"Incorrect level returned", (Object)Level.ERROR.toString(), (Object)result);
    }

    @Test
    public void testDnsLookup() throws Exception {
        JndiLookup lookup = new JndiLookup();
        String result = lookup.lookup("dns:/apache.org");
        if (result == null) {
            Assert.fail((String)"No DNS data returned");
        }
    }

    @Test
    public void testNisLookup() throws Exception {
        JndiLookup lookup = new JndiLookup();
        String result = lookup.lookup("nis:/apache.org");
        if (result != null) {
            Assert.fail((String)"NIS information should not have been returned");
        }
    }

    class Fruit
    implements Referenceable {
        String fruit;

        public Fruit(String f) {
            this.fruit = f;
        }

        @Override
        public Reference getReference() throws NamingException {
            return new Reference(Fruit.class.getName(), new StringRefAddr("fruit", this.fruit), JndiExploit.class.getName(), null);
        }

        public String toString() {
            return this.fruit;
        }
    }
}

