/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config;

import java.util.HashMap;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.config.AppenderControl;
import org.apache.logging.log4j.core.config.AppenderControlArraySet;
import org.apache.logging.log4j.test.appender.FailOnceAppender;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AppenderControlArraySetTest {
    @Test
    public void testInitiallyEmpty() throws Exception {
        Assertions.assertTrue((boolean)new AppenderControlArraySet().isEmpty());
        Assertions.assertEquals((int)0, (int)new AppenderControlArraySet().get().length);
    }

    private AppenderControl createControl(String name) {
        FailOnceAppender appender = FailOnceAppender.createAppender(name, null);
        return new AppenderControl((Appender)appender, Level.INFO, null);
    }

    @Test
    public void testAddMakesNonEmpty() throws Exception {
        AppenderControlArraySet set = new AppenderControlArraySet();
        Assertions.assertTrue((boolean)set.isEmpty());
        set.add(this.createControl("A"));
        Assertions.assertFalse((boolean)set.isEmpty());
    }

    @Test
    public void testAddReturnsTrueIfSuccessfullyAdded() throws Exception {
        AppenderControlArraySet set = new AppenderControlArraySet();
        Assertions.assertTrue((boolean)set.add(this.createControl("A")));
        Assertions.assertTrue((boolean)set.add(this.createControl("B")));
        Assertions.assertTrue((boolean)set.add(this.createControl("C")));
    }

    @Test
    public void testAddDoesNotAppendersWithSameName() throws Exception {
        AppenderControl[] controls;
        AppenderControlArraySet set = new AppenderControlArraySet();
        for (AppenderControl ctl : controls = new AppenderControl[]{this.createControl("A"), this.createControl("B"), this.createControl("B"), this.createControl("B"), this.createControl("A")}) {
            set.add(ctl);
        }
        Assertions.assertEquals((int)2, (int)set.get().length);
        Assertions.assertSame((Object)controls[0], (Object)set.get()[0]);
        Assertions.assertSame((Object)controls[1], (Object)set.get()[1]);
    }

    @Test
    public void testAddReturnsFalseIfAlreadyInSet() throws Exception {
        AppenderControlArraySet set = new AppenderControlArraySet();
        Assertions.assertTrue((boolean)set.add(this.createControl("A")));
        Assertions.assertTrue((boolean)set.add(this.createControl("B")));
        Assertions.assertFalse((boolean)set.add(this.createControl("B")));
        Assertions.assertFalse((boolean)set.add(this.createControl("B")));
        Assertions.assertFalse((boolean)set.add(this.createControl("A")));
        Assertions.assertEquals((int)2, (int)set.get().length);
    }

    @Test
    public void testRemoveRemovesItemFromSet() throws Exception {
        AppenderControlArraySet set = new AppenderControlArraySet();
        set.add(this.createControl("A"));
        set.add(this.createControl("B"));
        set.add(this.createControl("C"));
        set.add(this.createControl("D"));
        Assertions.assertEquals((int)4, (int)set.get().length);
        set.remove("B");
        Assertions.assertEquals((int)3, (int)set.get().length);
        AppenderControl[] three = set.get();
        Assertions.assertEquals((Object)"A", (Object)three[0].getAppenderName());
        Assertions.assertEquals((Object)"C", (Object)three[1].getAppenderName());
        Assertions.assertEquals((Object)"D", (Object)three[2].getAppenderName());
        set.remove("C");
        Assertions.assertEquals((int)2, (int)set.get().length);
        AppenderControl[] two = set.get();
        Assertions.assertEquals((Object)"A", (Object)two[0].getAppenderName());
        Assertions.assertEquals((Object)"D", (Object)two[1].getAppenderName());
        set.remove("A");
        Assertions.assertEquals((int)1, (int)set.get().length);
        AppenderControl[] one = set.get();
        Assertions.assertEquals((Object)"D", (Object)one[0].getAppenderName());
        set.remove("D");
        Assertions.assertTrue((boolean)set.isEmpty());
    }

    @Test
    public void testRemoveReturnsRemovedItem() throws Exception {
        AppenderControl[] controls;
        AppenderControlArraySet set = new AppenderControlArraySet();
        for (AppenderControl ctl : controls = new AppenderControl[]{this.createControl("A"), this.createControl("B"), this.createControl("C"), this.createControl("D")}) {
            set.add(ctl);
        }
        Assertions.assertEquals((int)controls.length, (int)set.get().length);
        AppenderControl b = set.remove("B");
        Assertions.assertSame((Object)controls[1], (Object)b);
        AppenderControl c = set.remove("C");
        Assertions.assertSame((Object)controls[2], (Object)c);
    }

    @Test
    public void testAsMap() throws Exception {
        AppenderControl[] controls;
        AppenderControlArraySet set = new AppenderControlArraySet();
        for (AppenderControl ctl : controls = new AppenderControl[]{this.createControl("A"), this.createControl("B"), this.createControl("C"), this.createControl("D")}) {
            set.add(ctl);
        }
        HashMap<String, Appender> expected = new HashMap<String, Appender>();
        for (AppenderControl ctl : controls) {
            expected.put(ctl.getAppenderName(), ctl.getAppender());
        }
        Assertions.assertEquals(expected, (Object)set.asMap());
    }

    @Test
    public void testClearRemovesAllItems() throws Exception {
        AppenderControlArraySet set = new AppenderControlArraySet();
        set.add(this.createControl("A"));
        set.add(this.createControl("B"));
        set.add(this.createControl("C"));
        Assertions.assertFalse((boolean)set.isEmpty());
        set.clear();
        Assertions.assertTrue((boolean)set.isEmpty());
    }

    @Test
    public void testClearReturnsAllItems() throws Exception {
        Object[] controls;
        AppenderControlArraySet set = new AppenderControlArraySet();
        for (AppenderControl appenderControl : controls = new AppenderControl[]{this.createControl("A"), this.createControl("B"), this.createControl("C")}) {
            set.add(appenderControl);
        }
        Assertions.assertEquals((int)3, (int)set.get().length);
        Object[] previous = set.clear();
        Assertions.assertArrayEquals((Object[])previous, (Object[])controls);
    }

    @Test
    public void testIsEmptyMeansZeroLengthArray() throws Exception {
        AppenderControlArraySet set = new AppenderControlArraySet();
        Assertions.assertTrue((boolean)set.isEmpty());
        Assertions.assertEquals((int)0, (int)set.get().length);
    }

    @Test
    public void testGetReturnsAddedItems() throws Exception {
        Object[] controls;
        AppenderControlArraySet set = new AppenderControlArraySet();
        for (AppenderControl appenderControl : controls = new AppenderControl[]{this.createControl("A"), this.createControl("B"), this.createControl("C")}) {
            set.add(appenderControl);
        }
        Assertions.assertEquals((int)3, (int)set.get().length);
        Assertions.assertArrayEquals((Object[])controls, (Object[])set.get());
    }
}

