/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.async;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.categories.AsyncLoggers;
import org.apache.logging.log4j.core.CoreLoggerContexts;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.async.AsyncLoggerContext;
import org.apache.logging.log4j.core.selector.ContextSelector;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={AsyncLoggers.class})
public class AsyncLoggerCustomSelectorLocationTest {
    @BeforeClass
    public static void beforeClass() {
        File file = new File("target", "AsyncLoggerCustomSelectorLocationTest.log");
        file.delete();
        System.setProperty("Log4jContextSelector", CustomAsyncContextSelector.class.getName());
        System.setProperty("log4j.configurationFile", "AsyncLoggerCustomSelectorLocationTest.xml");
    }

    @AfterClass
    public static void afterClass() {
        System.setProperty("Log4jContextSelector", "");
    }

    @Test
    public void testCustomAsyncSelectorLocation() throws Exception {
        File file = new File("target", "AsyncLoggerCustomSelectorLocationTest.log");
        Logger log = LogManager.getLogger((String)"com.foo.Bar");
        Logger logIncludingLocation = LogManager.getLogger((String)"com.include.location.Bar");
        String msg = "Async logger msg with location";
        log.info("Async logger msg with location");
        logIncludingLocation.info("Async logger msg with location");
        CoreLoggerContexts.stopLoggerContext(false, file);
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String firstLine = reader.readLine();
        String secondLine = reader.readLine();
        String thirdLine = reader.readLine();
        reader.close();
        file.delete();
        MatcherAssert.assertThat((Object)firstLine, (Matcher)CoreMatchers.containsString((String)"Async logger msg with location"));
        MatcherAssert.assertThat((Object)firstLine, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"testCustomAsyncSelectorLocation")));
        MatcherAssert.assertThat((Object)secondLine, (Matcher)CoreMatchers.containsString((String)"Async logger msg with location"));
        MatcherAssert.assertThat((Object)secondLine, (Matcher)CoreMatchers.containsString((String)"testCustomAsyncSelectorLocation"));
        MatcherAssert.assertThat((Object)thirdLine, (Matcher)CoreMatchers.nullValue());
    }

    public static final class CustomAsyncContextSelector
    implements ContextSelector {
        private static final LoggerContext CONTEXT = new AsyncLoggerContext("AsyncDefault");

        public LoggerContext getContext(String fqcn, ClassLoader loader, boolean currentContext) {
            return CONTEXT;
        }

        public LoggerContext getContext(String fqcn, ClassLoader loader, boolean currentContext, URI configLocation) {
            return CONTEXT;
        }

        public List<LoggerContext> getLoggerContexts() {
            return Collections.singletonList(CONTEXT);
        }

        public void removeContext(LoggerContext context) {
        }

        public boolean isClassLoaderDependent() {
            return false;
        }
    }
}

