/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling.action;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import org.apache.logging.log4j.core.appender.rolling.action.DummyFileAttributes;
import org.apache.logging.log4j.core.appender.rolling.action.PathSortByModificationTime;
import org.apache.logging.log4j.core.appender.rolling.action.PathSorter;
import org.apache.logging.log4j.core.appender.rolling.action.PathWithAttributes;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PathSortByModificationTimeTest {
    @Test
    public void testIsRecentFirstReturnsConstructorValue() {
        Assertions.assertTrue((boolean)((PathSortByModificationTime)PathSortByModificationTime.createSorter((boolean)true)).isRecentFirst());
        Assertions.assertFalse((boolean)((PathSortByModificationTime)PathSortByModificationTime.createSorter((boolean)false)).isRecentFirst());
    }

    @Test
    public void testCompareRecentFirst() {
        PathSorter sorter = PathSortByModificationTime.createSorter((boolean)true);
        Path p1 = Paths.get("aaa", new String[0]);
        Path p2 = Paths.get("bbb", new String[0]);
        DummyFileAttributes a1 = new DummyFileAttributes();
        DummyFileAttributes a2 = new DummyFileAttributes();
        a1.lastModified = FileTime.fromMillis(100L);
        a2.lastModified = FileTime.fromMillis(222L);
        Assertions.assertEquals((int)1, (int)sorter.compare((Object)this.path(p1, a1), (Object)this.path(p1, a2)), (String)"same path, 2nd more recent");
        Assertions.assertEquals((int)1, (int)sorter.compare((Object)this.path(p1, a1), (Object)this.path(p2, a2)), (String)"path ignored, 2nd more recent");
        Assertions.assertEquals((int)1, (int)sorter.compare((Object)this.path(p2, a1), (Object)this.path(p1, a2)), (String)"path ignored, 2nd more recent");
        Assertions.assertEquals((int)-1, (int)sorter.compare((Object)this.path(p1, a2), (Object)this.path(p1, a1)), (String)"same path, 1st more recent");
        Assertions.assertEquals((int)-1, (int)sorter.compare((Object)this.path(p1, a2), (Object)this.path(p2, a1)), (String)"path ignored, 1st more recent");
        Assertions.assertEquals((int)-1, (int)sorter.compare((Object)this.path(p2, a2), (Object)this.path(p1, a1)), (String)"path ignored, 1st more recent");
        Assertions.assertEquals((int)0, (int)sorter.compare((Object)this.path(p1, a1), (Object)this.path(p1, a1)), (String)"same path, same time");
        Assertions.assertEquals((int)1, (int)sorter.compare((Object)this.path(p1, a1), (Object)this.path(p2, a1)), (String)"p2 < p1, same time");
        Assertions.assertEquals((int)-1, (int)sorter.compare((Object)this.path(p2, a1), (Object)this.path(p1, a1)), (String)"p2 < p1, same time");
    }

    @Test
    public void testCompareRecentLast() {
        PathSorter sorter = PathSortByModificationTime.createSorter((boolean)false);
        Path p1 = Paths.get("aaa", new String[0]);
        Path p2 = Paths.get("bbb", new String[0]);
        DummyFileAttributes a1 = new DummyFileAttributes();
        DummyFileAttributes a2 = new DummyFileAttributes();
        a1.lastModified = FileTime.fromMillis(100L);
        a2.lastModified = FileTime.fromMillis(222L);
        Assertions.assertEquals((int)-1, (int)sorter.compare((Object)this.path(p1, a1), (Object)this.path(p1, a2)), (String)"same path, 2nd more recent");
        Assertions.assertEquals((int)-1, (int)sorter.compare((Object)this.path(p1, a1), (Object)this.path(p2, a2)), (String)"path ignored, 2nd more recent");
        Assertions.assertEquals((int)-1, (int)sorter.compare((Object)this.path(p2, a1), (Object)this.path(p1, a2)), (String)"path ignored, 2nd more recent");
        Assertions.assertEquals((int)1, (int)sorter.compare((Object)this.path(p1, a2), (Object)this.path(p1, a1)), (String)"same path, 1st more recent");
        Assertions.assertEquals((int)1, (int)sorter.compare((Object)this.path(p1, a2), (Object)this.path(p2, a1)), (String)"path ignored, 1st more recent");
        Assertions.assertEquals((int)1, (int)sorter.compare((Object)this.path(p2, a2), (Object)this.path(p1, a1)), (String)"path ignored, 1st more recent");
        Assertions.assertEquals((int)0, (int)sorter.compare((Object)this.path(p1, a1), (Object)this.path(p1, a1)), (String)"same path, same time");
        Assertions.assertEquals((int)-1, (int)sorter.compare((Object)this.path(p1, a1), (Object)this.path(p2, a1)), (String)"p1 < p2, same time");
        Assertions.assertEquals((int)1, (int)sorter.compare((Object)this.path(p2, a1), (Object)this.path(p1, a1)), (String)"p1 < p2, same time");
    }

    private PathWithAttributes path(Path path, DummyFileAttributes attributes) {
        return new PathWithAttributes(path, (BasicFileAttributes)attributes);
    }
}

