/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.categories.Layouts;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configurator;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.xml.sax.SAXException;

@Ignore
@Category(value={Layouts.Xml.class})
public class XmlCompactFileAppenderValidationTest {
    private LoggerContext loggerContext;

    @Before
    public void before() {
        this.loggerContext = Configurator.initialize((String)XmlCompactFileAppenderValidationTest.class.getName(), (String)"target/test-classes/XmlCompactFileAppenderValidationTest.xml");
    }

    @After
    public void after() {
        Configurator.shutdown((LoggerContext)this.loggerContext);
    }

    @Test
    public void validateXmlSchemaThrowable() throws Exception {
        File file = new File("target", "XmlCompactFileAppenderValidationTest.log.xml");
        file.delete();
        Logger log = LogManager.getLogger((String)"com.foo.Bar");
        try {
            throw new IllegalArgumentException("IAE");
        }
        catch (IllegalArgumentException e) {
            log.warn("Message 1", (Throwable)e);
            Configurator.shutdown((LoggerContext)this.loggerContext);
            this.validateXmlSchema(file);
            return;
        }
    }

    @Test
    public void validateXmlSchema() throws Exception {
        File file = new File("target", "XmlCompactFileAppenderValidationTest.log.xml");
        file.delete();
        Logger log = LogManager.getLogger((String)"com.foo.Bar");
        log.warn("Message 1");
        log.info("Message 2");
        log.debug("Message 3");
        Configurator.shutdown((LoggerContext)this.loggerContext);
        this.validateXmlSchema(file);
    }

    @Test
    public void validateXmlNoEvents() throws Exception {
        File file = new File("target", "XmlCompactFileAppenderValidationTest.log.xml");
        file.delete();
        Configurator.shutdown((LoggerContext)this.loggerContext);
        this.validateXmlSchema(file);
    }

    private void validateXmlSchema(File file) throws SAXException, IOException {
        URL schemaFile = this.getClass().getClassLoader().getResource("Log4j-events.xsd");
        StreamSource xmlFile = new StreamSource(file);
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = schemaFactory.newSchema(schemaFile);
        Validator validator = schema.newValidator();
        validator.validate(xmlFile);
    }
}

