/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.DefaultConfiguration;
import org.apache.logging.log4j.core.config.builder.impl.DefaultConfigurationBuilder;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.pattern.MessagePatternConverter;
import org.apache.logging.log4j.message.MapMessage;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.logging.log4j.message.SimpleMessage;
import org.apache.logging.log4j.message.StringMapMessage;
import org.apache.logging.log4j.message.StructuredDataMessage;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MessagePatternConverterTest {
    @Test
    public void testPattern() {
        MessagePatternConverter converter = MessagePatternConverter.newInstance(null, null);
        SimpleMessage msg = new SimpleMessage("Hello!");
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName("MyLogger").setLevel(Level.DEBUG).setMessage((Message)msg).build();
        StringBuilder sb = new StringBuilder();
        converter.format((LogEvent)event, sb);
        Assertions.assertEquals((Object)"Hello!", (Object)sb.toString(), (String)"Unexpected result");
        event = Log4jLogEvent.newBuilder().setLoggerName("MyLogger").setLevel(Level.DEBUG).setMessage(null).build();
        sb = new StringBuilder();
        converter.format((LogEvent)event, sb);
        Assertions.assertEquals((int)0, (int)sb.length(), (String)("Incorrect length: " + sb));
        msg = new SimpleMessage(null);
        event = Log4jLogEvent.newBuilder().setLoggerName("MyLogger").setLevel(Level.DEBUG).setMessage((Message)msg).build();
        sb = new StringBuilder();
        converter.format((LogEvent)event, sb);
        Assertions.assertEquals((int)4, (int)sb.length(), (String)("Incorrect length: " + sb));
    }

    @Test
    public void testPatternAndParameterizedMessageDateLookup() {
        MessagePatternConverter converter = MessagePatternConverter.newInstance(null, null);
        ParameterizedMessage msg = new ParameterizedMessage("${date:now:buhu}", new Object[0]);
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName("MyLogger").setLevel(Level.DEBUG).setMessage((Message)msg).build();
        StringBuilder sb = new StringBuilder();
        converter.format((LogEvent)event, sb);
        Assertions.assertEquals((Object)"${date:now:buhu}", (Object)sb.toString(), (String)"Unexpected result");
    }

    @Test
    public void testDefaultDisabledLookup() {
        Configuration config = new DefaultConfigurationBuilder().addProperty("foo", "bar").build(true);
        MessagePatternConverter converter = MessagePatternConverter.newInstance((Configuration)config, null);
        ParameterizedMessage msg = new ParameterizedMessage("${foo}", new Object[0]);
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName("MyLogger").setLevel(Level.DEBUG).setMessage((Message)msg).build();
        StringBuilder sb = new StringBuilder();
        converter.format((LogEvent)event, sb);
        Assertions.assertEquals((Object)"${foo}", (Object)sb.toString(), (String)"Unexpected result");
    }

    @Test
    public void testDisabledLookup() {
        Configuration config = new DefaultConfigurationBuilder().addProperty("foo", "bar").build(true);
        MessagePatternConverter converter = MessagePatternConverter.newInstance((Configuration)config, (String[])new String[]{"nolookups"});
        ParameterizedMessage msg = new ParameterizedMessage("${foo}", new Object[0]);
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName("MyLogger").setLevel(Level.DEBUG).setMessage((Message)msg).build();
        StringBuilder sb = new StringBuilder();
        converter.format((LogEvent)event, sb);
        Assertions.assertEquals((Object)"${foo}", (Object)sb.toString(), (String)"Expected the raw pattern string without lookup");
    }

    @Test
    public void testLookup() {
        Configuration config = new DefaultConfigurationBuilder().addProperty("foo", "bar").build(true);
        MessagePatternConverter converter = MessagePatternConverter.newInstance((Configuration)config, (String[])new String[]{"lookups"});
        ParameterizedMessage msg = new ParameterizedMessage("${foo}", new Object[0]);
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName("MyLogger").setLevel(Level.DEBUG).setMessage((Message)msg).build();
        StringBuilder sb = new StringBuilder();
        converter.format((LogEvent)event, sb);
        Assertions.assertEquals((Object)"bar", (Object)sb.toString(), (String)"Unexpected result");
    }

    @Test
    public void testPatternWithConfiguration() {
        DefaultConfiguration config = new DefaultConfiguration();
        MessagePatternConverter converter = MessagePatternConverter.newInstance((Configuration)config, null);
        SimpleMessage msg = new SimpleMessage("Hello!");
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName("MyLogger").setLevel(Level.DEBUG).setMessage((Message)msg).build();
        StringBuilder sb = new StringBuilder();
        converter.format((LogEvent)event, sb);
        Assertions.assertEquals((Object)"Hello!", (Object)sb.toString(), (String)"Unexpected result");
        event = Log4jLogEvent.newBuilder().setLoggerName("MyLogger").setLevel(Level.DEBUG).setMessage(null).build();
        sb = new StringBuilder();
        converter.format((LogEvent)event, sb);
        Assertions.assertEquals((int)0, (int)sb.length(), (String)("Incorrect length: " + sb));
        msg = new SimpleMessage(null);
        event = Log4jLogEvent.newBuilder().setLoggerName("MyLogger").setLevel(Level.DEBUG).setMessage((Message)msg).build();
        sb = new StringBuilder();
        converter.format((LogEvent)event, sb);
        Assertions.assertEquals((int)4, (int)sb.length(), (String)("Incorrect length: " + sb));
    }

    @Test
    public void testMapMessageFormatJson() {
        MessagePatternConverter converter = MessagePatternConverter.newInstance(null, (String[])new String[]{"json"});
        MapMessage msg = new StringMapMessage().with("key", "val");
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName("MyLogger").setLevel(Level.DEBUG).setMessage((Message)msg).build();
        StringBuilder sb = new StringBuilder();
        converter.format((LogEvent)event, sb);
        Assertions.assertEquals((Object)"{\"key\":\"val\"}", (Object)sb.toString(), (String)"Unexpected result");
    }

    @Test
    public void testMapMessageFormatXml() {
        MessagePatternConverter converter = MessagePatternConverter.newInstance(null, (String[])new String[]{"xml"});
        MapMessage msg = new StringMapMessage().with("key", "val");
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName("MyLogger").setLevel(Level.DEBUG).setMessage((Message)msg).build();
        StringBuilder sb = new StringBuilder();
        converter.format((LogEvent)event, sb);
        Assertions.assertEquals((Object)"<Map>\n  <Entry key=\"key\">val</Entry>\n</Map>", (Object)sb.toString(), (String)"Unexpected result");
    }

    @Test
    public void testMapMessageFormatDefault() {
        MessagePatternConverter converter = MessagePatternConverter.newInstance(null, null);
        MapMessage msg = new StringMapMessage().with("key", "val");
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName("MyLogger").setLevel(Level.DEBUG).setMessage((Message)msg).build();
        StringBuilder sb = new StringBuilder();
        converter.format((LogEvent)event, sb);
        Assertions.assertEquals((Object)"key=\"val\"", (Object)sb.toString(), (String)"Unexpected result");
    }

    @Test
    public void testStructuredDataFormatFull() {
        MessagePatternConverter converter = MessagePatternConverter.newInstance(null, (String[])new String[]{"FULL"});
        MapMessage msg = new StructuredDataMessage("id", "message", "type").with("key", "val");
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName("MyLogger").setLevel(Level.DEBUG).setMessage((Message)msg).build();
        StringBuilder sb = new StringBuilder();
        converter.format((LogEvent)event, sb);
        Assertions.assertEquals((Object)"type [id key=\"val\"] message", (Object)sb.toString(), (String)"Unexpected result");
    }
}

