/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.parser;

import java.nio.charset.StandardCharsets;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.parser.LogEventParserTest;
import org.apache.logging.log4j.core.parser.ParseException;
import org.apache.logging.log4j.core.parser.YamlLogEventParser;
import org.junit.Before;
import org.junit.Test;

public class YamlLogEventParserTest
extends LogEventParserTest {
    private YamlLogEventParser parser;
    private static final String YAML = "---\ntimeMillis: 1493121664118\ninstant:\n epochSecond: 1493121664\n nanoOfSecond: 118000000\nthread: \"main\"\nlevel: \"INFO\"\nloggerName: \"HelloWorld\"\nmarker:\n name: \"child\"\n parents:\n - name: \"parent\"\n   parents:\n   - name: \"grandparent\"\nmessage: \"Hello, world!\"\nthrown:\n commonElementCount: 0\n message: \"error message\"\n name: \"java.lang.RuntimeException\"\n extendedStackTrace:\n - class: \"logtest.Main\"\n   method: \"main\"\n   file: \"Main.java\"\n   line: 29\n   exact: true\n   location: \"classes/\"\n   version: \"?\"\ncontextStack:\n- \"one\"\n- \"two\"\nendOfBatch: false\nloggerFqcn: \"org.apache.logging.log4j.spi.AbstractLogger\"\ncontextMap:\n bar: \"BAR\"\n foo: \"FOO\"\nthreadId: 1\nthreadPriority: 5\nsource:\n class: \"logtest.Main\"\n method: \"main\"\n file: \"Main.java\"\n line: 29";

    @Before
    public void setup() {
        this.parser = new YamlLogEventParser();
    }

    @Test
    public void testString() throws ParseException {
        LogEvent logEvent = this.parser.parseFrom(YAML);
        this.assertLogEvent(logEvent);
    }

    @Test(expected=ParseException.class)
    public void testStringEmpty() throws ParseException {
        this.parser.parseFrom("");
    }

    @Test(expected=ParseException.class)
    public void testStringInvalidYaml() throws ParseException {
        this.parser.parseFrom("foobar");
    }

    @Test
    public void testEmptyObject() throws ParseException {
        this.parser.parseFrom("---\n");
    }

    @Test
    public void testTimeMillisIgnored() throws ParseException {
        this.parser.parseFrom("---\ntimeMillis: \"foobar\"\n");
    }

    @Test(expected=ParseException.class)
    public void testStringWrongPropertyType() throws ParseException {
        this.parser.parseFrom("---\nthreadId: \"foobar\"\n");
    }

    @Test
    public void testStringIgnoreInvalidProperty() throws ParseException {
        this.parser.parseFrom("---\nfoo: \"bar\"\n");
    }

    @Test
    public void testByteArray() throws ParseException {
        LogEvent logEvent = this.parser.parseFrom(YAML.getBytes(StandardCharsets.UTF_8));
        this.assertLogEvent(logEvent);
    }

    @Test
    public void testByteArrayOffsetLength() throws ParseException {
        byte[] bytes = "abc---\ntimeMillis: 1493121664118\ninstant:\n epochSecond: 1493121664\n nanoOfSecond: 118000000\nthread: \"main\"\nlevel: \"INFO\"\nloggerName: \"HelloWorld\"\nmarker:\n name: \"child\"\n parents:\n - name: \"parent\"\n   parents:\n   - name: \"grandparent\"\nmessage: \"Hello, world!\"\nthrown:\n commonElementCount: 0\n message: \"error message\"\n name: \"java.lang.RuntimeException\"\n extendedStackTrace:\n - class: \"logtest.Main\"\n   method: \"main\"\n   file: \"Main.java\"\n   line: 29\n   exact: true\n   location: \"classes/\"\n   version: \"?\"\ncontextStack:\n- \"one\"\n- \"two\"\nendOfBatch: false\nloggerFqcn: \"org.apache.logging.log4j.spi.AbstractLogger\"\ncontextMap:\n bar: \"BAR\"\n foo: \"FOO\"\nthreadId: 1\nthreadPriority: 5\nsource:\n class: \"logtest.Main\"\n method: \"main\"\n file: \"Main.java\"\n line: 29def".getBytes(StandardCharsets.UTF_8);
        LogEvent logEvent = this.parser.parseFrom(bytes, 3, bytes.length - 6);
        this.assertLogEvent(logEvent);
    }
}

