/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config;

import java.io.File;
import java.net.URI;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configurator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="functional")
public class ConfiguratorTest {
    @Test
    public void testInitializeFromAbsoluteFilePath() {
        String path = new File("src/test/resources/log4j-list.xml").getAbsolutePath();
        this.testInitializeFromFilePath(path);
    }

    @Test
    public void testInitializeFromRelativeFilePath() {
        String path = new File("src/test/resources/log4j-list.xml").toString();
        this.testInitializeFromFilePath(path);
    }

    @Test
    public void testReconfigure() {
        String path = new File("src/test/resources/log4j-list.xml").getAbsolutePath();
        try (LoggerContext loggerContext = Configurator.initialize((String)this.getClass().getName(), null, (String)path);){
            Assertions.assertNotNull((Object)loggerContext.getConfiguration().getAppender("List"));
            URI uri = loggerContext.getConfigLocation();
            Assertions.assertNotNull((Object)uri, (String)"No configuration location returned");
            Configurator.reconfigure();
            Assertions.assertEquals((Object)uri, (Object)loggerContext.getConfigLocation(), (String)"Unexpected configuration location returned");
        }
    }

    @Test
    public void testReconfigureFromPath() {
        String path = new File("src/test/resources/log4j-list.xml").getAbsolutePath();
        try (LoggerContext loggerContext = Configurator.initialize((String)this.getClass().getName(), null, (String)path);){
            Assertions.assertNotNull((Object)loggerContext.getConfiguration().getAppender("List"));
            URI uri = loggerContext.getConfigLocation();
            Assertions.assertNotNull((Object)uri, (String)"No configuration location returned");
            URI location = new File("src/test/resources/log4j2-config.xml").toURI();
            Configurator.reconfigure((URI)location);
            Assertions.assertEquals((Object)location, (Object)loggerContext.getConfigLocation(), (String)"Unexpected configuration location returned");
        }
    }

    private void testInitializeFromFilePath(String path) {
        try (LoggerContext loggerContext = Configurator.initialize((String)this.getClass().getName(), null, (String)path);){
            Assertions.assertNotNull((Object)loggerContext.getConfiguration().getAppender("List"));
        }
    }
}

