/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling;

import java.io.File;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;

public class RollingAppenderCustomDeleteActionTest {
    private static final String CONFIG = "log4j-rolling-with-custom-delete.xml";
    private static final String DIR = "target/rolling-with-delete/test";
    private final LoggerContextRule loggerContextRule = LoggerContextRule.createShutdownTimeoutLoggerContextRule("log4j-rolling-with-custom-delete.xml");
    @Rule
    public RuleChain chain = this.loggerContextRule.withCleanFoldersRule("target/rolling-with-delete/test");

    @Test
    public void testAppender() throws Exception {
        Logger logger = this.loggerContextRule.getLogger();
        for (int i = 0; i < 10; ++i) {
            logger.debug("This is a test message number " + i);
        }
        Thread.sleep(100L);
        File dir = new File(DIR);
        Assert.assertTrue((String)"Dir target/rolling-with-delete/test should exist", (boolean)dir.exists());
        Assert.assertTrue((String)"Dir target/rolling-with-delete/test should contain files", (dir.listFiles().length > 0 ? 1 : 0) != 0);
        int MAX_TRIES = 20;
        for (int i = 0; i < 20; ++i) {
            File[] files;
            for (File file : files = dir.listFiles()) {
                System.out.println(file);
            }
            if (files.length == 3) {
                for (File file : files) {
                    Assert.assertTrue((String)"test-4.log should have been deleted", (boolean)Arrays.asList("test-1.log", "test-2.log", "test-3.log").contains(file.getName()));
                }
                return;
            }
            logger.debug("Adding additional event " + i);
            Thread.sleep(100L);
        }
        Assert.fail((String)"No rollover files found");
    }

    public static void main(String[] args) {
        Pattern p = Pattern.compile("test-.?[2,4,6,8,0]\\.log\\.gz");
        for (int i = 0; i < 16; ++i) {
            String str = "test-" + i + ".log.gz";
            Matcher m = p.matcher(str);
            System.out.println(m.matches() + ": " + str);
        }
    }
}

