/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.categories.Layouts;
import org.apache.logging.log4j.core.CoreLoggerContexts;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={Layouts.Xml.class})
public class XmlCompactFileAppenderTest {
    @BeforeClass
    public static void beforeClass() {
        System.setProperty("log4j.configurationFile", "XmlCompactFileAppenderTest.xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFlushAtEndOfBatch() throws Exception {
        String line1;
        File file = new File("target", "XmlCompactFileAppenderTest.log");
        file.delete();
        Logger log = LogManager.getLogger((String)"com.foo.Bar");
        String logMsg = "Message flushed with immediate flush=false";
        log.info("Message flushed with immediate flush=false");
        CoreLoggerContexts.stopLoggerContext(false, file);
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            line1 = reader.readLine();
        }
        finally {
            file.delete();
        }
        Assert.assertNotNull((String)"line1", (Object)line1);
        String msg1 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
        Assert.assertTrue((String)("line1 incorrect: [" + line1 + "], does not contain: [" + "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + ']'), (boolean)line1.contains("<?xml version=\"1.0\" encoding=\"UTF-8\"?>"));
        String msg2 = "<Events xmlns=\"http://logging.apache.org/log4j/2.0/events\">";
        Assert.assertTrue((String)("line1 incorrect: [" + line1 + "], does not contain: [" + "<Events xmlns=\"http://logging.apache.org/log4j/2.0/events\">" + ']'), (boolean)line1.contains("<Events xmlns=\"http://logging.apache.org/log4j/2.0/events\">"));
        String msg3 = "<Event ";
        Assert.assertTrue((String)("line1 incorrect: [" + line1 + "], does not contain: [" + "<Event " + ']'), (boolean)line1.contains("<Event "));
        String msg4 = "Message flushed with immediate flush=false";
        Assert.assertTrue((String)("line1 incorrect: [" + line1 + "], does not contain: [" + "Message flushed with immediate flush=false" + ']'), (boolean)line1.contains("Message flushed with immediate flush=false"));
        String location = "testFlushAtEndOfBatch";
        Assert.assertTrue((String)"no location", (!line1.contains("testFlushAtEndOfBatch") ? 1 : 0) != 0);
        Assert.assertTrue((line1.indexOf(13) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((line1.indexOf(10) == -1 ? 1 : 0) != 0);
    }
}

