/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.junit.WireMockRule;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import java.io.IOException;
import java.net.URL;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AppenderLoggingException;
import org.apache.logging.log4j.core.appender.HttpAppender;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.layout.JsonLayout;
import org.apache.logging.log4j.core.lookup.JavaLookup;
import org.apache.logging.log4j.core.net.ssl.KeyStoreConfiguration;
import org.apache.logging.log4j.core.net.ssl.SslConfiguration;
import org.apache.logging.log4j.core.net.ssl.TestConstants;
import org.apache.logging.log4j.core.net.ssl.TrustStoreConfiguration;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.SimpleMessage;
import org.apache.logging.log4j.status.StatusData;
import org.apache.logging.log4j.status.StatusListener;
import org.apache.logging.log4j.status.StatusLogger;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;

public class HttpAppenderTest {
    private static final String LOG_MESSAGE = "Hello, world!";
    private final ResponseDefinitionBuilder SUCCESS_RESPONSE = WireMock.aResponse().withStatus(201).withHeader("Content-Type", new String[]{"application/json"}).withBody("{\"status\":\"created\"}");
    private final ResponseDefinitionBuilder FAILURE_RESPONSE = WireMock.aResponse().withStatus(400).withHeader("Content-Type", new String[]{"application/json"}).withBody("{\"status\":\"error\"}");
    private final JavaLookup JAVA_LOOKUP = new JavaLookup();
    @Rule
    public LoggerContextRule ctx = new LoggerContextRule("HttpAppenderTest.xml");
    @Rule
    public WireMockRule wireMockRule = new WireMockRule((Options)WireMockConfiguration.wireMockConfig().dynamicPort().dynamicHttpsPort().keystorePath("src/test/resources/org/apache/logging/log4j/core/net/ssl/client.log4j2-keystore.jks").keystorePassword(String.valueOf(TestConstants.KEYSTORE_PWD())).keystoreType("JKS"));
    volatile StatusData error;

    @BeforeClass
    public static void setupClass() {
        Assume.assumeFalse((boolean)SystemUtils.IS_OS_WINDOWS);
    }

    private static Log4jLogEvent createLogEvent() {
        return Log4jLogEvent.newBuilder().setLoggerName(HttpAppenderTest.class.getName()).setLoggerFqcn(HttpAppenderTest.class.getName()).setLevel(Level.INFO).setMessage((Message)new SimpleMessage(LOG_MESSAGE)).build();
    }

    @Test
    public void testAppend() throws Exception {
        this.wireMockRule.stubFor(WireMock.post((UrlPattern)WireMock.urlEqualTo((String)"/test/log4j/")).willReturn(this.SUCCESS_RESPONSE));
        HttpAppender appender = ((HttpAppender.Builder)((HttpAppender.Builder)((HttpAppender.Builder)HttpAppender.newBuilder().setName("Http")).setLayout((Layout)JsonLayout.createDefaultLayout())).setConfiguration(this.ctx.getConfiguration())).setUrl(new URL("http://localhost:" + this.wireMockRule.port() + "/test/log4j/")).build();
        appender.append((LogEvent)HttpAppenderTest.createLogEvent());
        this.wireMockRule.verify(WireMock.postRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/test/log4j/")).withHeader("Host", WireMock.containing((String)"localhost")).withHeader("Content-Type", WireMock.containing((String)"application/json")).withRequestBody((ContentPattern)WireMock.containing((String)"\"message\" : \"Hello, world!\"")));
    }

    @Test
    public void testAppendHttps() throws Exception {
        this.wireMockRule.stubFor(WireMock.post((UrlPattern)WireMock.urlEqualTo((String)"/test/log4j/")).willReturn(this.SUCCESS_RESPONSE));
        HttpAppender appender = ((HttpAppender.Builder)((HttpAppender.Builder)((HttpAppender.Builder)HttpAppender.newBuilder().setName("Http")).setLayout((Layout)JsonLayout.createDefaultLayout())).setConfiguration(this.ctx.getConfiguration())).setUrl(new URL("https://localhost:" + this.wireMockRule.httpsPort() + "/test/log4j/")).setSslConfiguration(SslConfiguration.createSSLConfiguration(null, (KeyStoreConfiguration)KeyStoreConfiguration.createKeyStoreConfiguration((String)"src/test/resources/org/apache/logging/log4j/core/net/ssl/client.log4j2-keystore.jks", (char[])TestConstants.KEYSTORE_PWD(), (String)"JKS", null), (TrustStoreConfiguration)TrustStoreConfiguration.createKeyStoreConfiguration((String)"src/test/resources/org/apache/logging/log4j/core/net/ssl/truststore.jks", (char[])TestConstants.TRUSTSTORE_PWD(), (String)"JKS", null))).setVerifyHostname(false).build();
        appender.append((LogEvent)HttpAppenderTest.createLogEvent());
        this.wireMockRule.verify(WireMock.postRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/test/log4j/")).withHeader("Host", WireMock.containing((String)"localhost")).withHeader("Content-Type", WireMock.containing((String)"application/json")).withRequestBody((ContentPattern)WireMock.containing((String)"\"message\" : \"Hello, world!\"")));
    }

    @Test
    public void testAppendMethodPut() throws Exception {
        this.wireMockRule.stubFor(WireMock.put((UrlPattern)WireMock.urlEqualTo((String)"/test/log4j/1234")).willReturn(this.SUCCESS_RESPONSE));
        HttpAppender appender = ((HttpAppender.Builder)((HttpAppender.Builder)((HttpAppender.Builder)HttpAppender.newBuilder().setName("Http")).setLayout((Layout)JsonLayout.createDefaultLayout())).setConfiguration(this.ctx.getConfiguration())).setMethod("PUT").setUrl(new URL("http://localhost:" + this.wireMockRule.port() + "/test/log4j/1234")).build();
        appender.append((LogEvent)HttpAppenderTest.createLogEvent());
        this.wireMockRule.verify(WireMock.putRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/test/log4j/1234")).withHeader("Host", WireMock.containing((String)"localhost")).withHeader("Content-Type", WireMock.containing((String)"application/json")).withRequestBody((ContentPattern)WireMock.containing((String)"\"message\" : \"Hello, world!\"")));
    }

    @Test
    public void testAppendCustomHeader() throws Exception {
        this.wireMockRule.stubFor(WireMock.post((UrlPattern)WireMock.urlEqualTo((String)"/test/log4j/")).willReturn(this.SUCCESS_RESPONSE));
        HttpAppender appender = ((HttpAppender.Builder)((HttpAppender.Builder)((HttpAppender.Builder)HttpAppender.newBuilder().setName("Http")).setLayout((Layout)JsonLayout.createDefaultLayout())).setConfiguration(this.ctx.getConfiguration())).setUrl(new URL("http://localhost:" + this.wireMockRule.port() + "/test/log4j/")).setHeaders(new Property[]{Property.createProperty((String)"X-Test", (String)"header value"), Property.createProperty((String)"X-Runtime", (String)"${java:runtime}")}).build();
        appender.append((LogEvent)HttpAppenderTest.createLogEvent());
        this.wireMockRule.verify(WireMock.postRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/test/log4j/")).withHeader("Host", WireMock.containing((String)"localhost")).withHeader("X-Test", WireMock.equalTo((String)"header value")).withHeader("X-Runtime", WireMock.equalTo((String)this.JAVA_LOOKUP.getRuntime())).withHeader("Content-Type", WireMock.containing((String)"application/json")).withRequestBody((ContentPattern)WireMock.containing((String)"\"message\" : \"Hello, world!\"")));
    }

    @Test
    public void testAppendErrorIgnore() throws Exception {
        this.wireMockRule.stubFor(WireMock.post((UrlPattern)WireMock.urlEqualTo((String)"/test/log4j/")).willReturn(this.FAILURE_RESPONSE));
        StatusLogger.getLogger().registerListener(new StatusListener(){

            public void log(StatusData data) {
                HttpAppenderTest.this.error = data;
            }

            public Level getStatusLevel() {
                return Level.ERROR;
            }

            public void close() throws IOException {
            }
        });
        this.error = null;
        HttpAppender appender = ((HttpAppender.Builder)((HttpAppender.Builder)((HttpAppender.Builder)HttpAppender.newBuilder().setName("Http")).setLayout((Layout)JsonLayout.createDefaultLayout())).setConfiguration(this.ctx.getConfiguration())).setUrl(new URL("http://localhost:" + this.wireMockRule.port() + "/test/log4j/")).build();
        appender.append((LogEvent)HttpAppenderTest.createLogEvent());
        this.wireMockRule.verify(WireMock.postRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/test/log4j/")).withHeader("Host", WireMock.containing((String)"localhost")).withHeader("Content-Type", WireMock.containing((String)"application/json")).withRequestBody((ContentPattern)WireMock.containing((String)"\"message\" : \"Hello, world!\"")));
        Assert.assertNotNull((Object)this.error);
        Assert.assertEquals((Object)Level.ERROR, (Object)this.error.getLevel());
        Assert.assertEquals((Object)"Unable to send HTTP in appender [Http]", (Object)this.error.getMessage().toString());
    }

    @Test(expected=AppenderLoggingException.class)
    public void testAppendError() throws Exception {
        this.wireMockRule.stubFor(WireMock.post((UrlPattern)WireMock.urlEqualTo((String)"/test/log4j/")).willReturn(this.FAILURE_RESPONSE));
        HttpAppender appender = ((HttpAppender.Builder)((HttpAppender.Builder)((HttpAppender.Builder)((HttpAppender.Builder)HttpAppender.newBuilder().setName("Http")).setLayout((Layout)JsonLayout.createDefaultLayout())).setConfiguration(this.ctx.getConfiguration())).setIgnoreExceptions(false)).setUrl(new URL("http://localhost:" + this.wireMockRule.port() + "/test/log4j/")).build();
        appender.append((LogEvent)HttpAppenderTest.createLogEvent());
    }

    @Test(expected=AppenderLoggingException.class)
    public void testAppendConnectError() throws Exception {
        HttpAppender appender = ((HttpAppender.Builder)((HttpAppender.Builder)((HttpAppender.Builder)((HttpAppender.Builder)HttpAppender.newBuilder().setName("Http")).setLayout((Layout)JsonLayout.createDefaultLayout())).setConfiguration(this.ctx.getConfiguration())).setIgnoreExceptions(false)).setUrl(new URL("http://localhost:" + (this.wireMockRule.port() + 1) + "/test/log4j/")).build();
        appender.append((LogEvent)HttpAppenderTest.createLogEvent());
    }
}

