/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.util;

import org.apache.logging.log4j.core.util.CyclicBuffer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CyclicBufferTest {
    @Test
    public void testSize0() {
        CyclicBuffer buffer = new CyclicBuffer(Integer.class, 0);
        Assertions.assertTrue((boolean)buffer.isEmpty());
        buffer.add((Object)1);
        Assertions.assertTrue((boolean)buffer.isEmpty());
        Integer[] items = (Integer[])buffer.removeAll();
        Assertions.assertEquals((int)0, (int)items.length, (String)"Incorrect number of items");
        Assertions.assertTrue((boolean)buffer.isEmpty());
        buffer.add((Object)1);
        buffer.add((Object)2);
        buffer.add((Object)3);
        buffer.add((Object)4);
        items = (Integer[])buffer.removeAll();
        Assertions.assertEquals((int)0, (int)items.length, (String)"Incorrect number of items");
        Assertions.assertTrue((boolean)buffer.isEmpty());
    }

    @Test
    public void testSize1() {
        CyclicBuffer buffer = new CyclicBuffer(Integer.class, 1);
        Assertions.assertTrue((boolean)buffer.isEmpty());
        buffer.add((Object)1);
        Assertions.assertFalse((boolean)buffer.isEmpty());
        Object[] items = (Integer[])buffer.removeAll();
        Assertions.assertEquals((int)1, (int)items.length, (String)"Incorrect number of items");
        Assertions.assertTrue((boolean)buffer.isEmpty());
        buffer.add((Object)1);
        buffer.add((Object)2);
        buffer.add((Object)3);
        buffer.add((Object)4);
        items = (Integer[])buffer.removeAll();
        Assertions.assertEquals((int)1, (int)items.length, (String)"Incorrect number of items");
        Assertions.assertArrayEquals((Object[])new Integer[]{4}, (Object[])items);
        Assertions.assertTrue((boolean)buffer.isEmpty());
    }

    @Test
    public void testSize3() {
        CyclicBuffer buffer = new CyclicBuffer(Integer.class, 3);
        Assertions.assertTrue((boolean)buffer.isEmpty());
        buffer.add((Object)1);
        Assertions.assertFalse((boolean)buffer.isEmpty());
        Object[] items = (Integer[])buffer.removeAll();
        Assertions.assertEquals((int)1, (int)items.length, (String)"Incorrect number of items");
        Assertions.assertTrue((boolean)buffer.isEmpty());
        buffer.add((Object)1);
        buffer.add((Object)2);
        buffer.add((Object)3);
        buffer.add((Object)4);
        items = (Integer[])buffer.removeAll();
        Assertions.assertEquals((int)3, (int)items.length, (String)"Incorrect number of items");
        Assertions.assertArrayEquals((Object[])new Integer[]{2, 3, 4}, (Object[])items);
        Assertions.assertTrue((boolean)buffer.isEmpty());
    }

    @Test
    public void testSizeNegative() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new CyclicBuffer(Integer.class, -1));
    }
}

