/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.util;

import java.lang.reflect.Field;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.logging.log4j.core.async.AsyncLogger;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.util.CachedClock;
import org.apache.logging.log4j.core.util.Clock;
import org.apache.logging.log4j.core.util.ClockFactory;
import org.apache.logging.log4j.core.util.CoarseCachedClock;
import org.apache.logging.log4j.core.util.SystemClock;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.EnabledOnJre;
import org.junit.jupiter.api.condition.JRE;

@EnabledOnJre(value={JRE.JAVA_8, JRE.JAVA_9, JRE.JAVA_10, JRE.JAVA_11})
public class ClockFactoryTest {
    public static void resetClocks() throws IllegalAccessException {
        ClockFactoryTest.resetClock(Log4jLogEvent.class);
        ClockFactoryTest.resetClock(AsyncLogger.class);
    }

    public static void resetClock(Class<?> clazz) throws IllegalAccessException {
        System.clearProperty("log4j.Clock");
        Field field = FieldUtils.getField(clazz, (String)"CLOCK", (boolean)true);
        FieldUtils.removeFinalModifier((Field)field);
        FieldUtils.writeStaticField((Field)field, (Object)ClockFactory.getClock(), (boolean)false);
    }

    @BeforeEach
    public void setUp() throws Exception {
        ClockFactoryTest.resetClocks();
    }

    @Test
    public void testDefaultIsSystemClock() {
        System.clearProperty("log4j.Clock");
        Assertions.assertSame(SystemClock.class, ClockFactory.getClock().getClass());
    }

    @Test
    public void testSpecifySystemClockShort() {
        System.setProperty("log4j.Clock", "SystemClock");
        Assertions.assertSame(SystemClock.class, ClockFactory.getClock().getClass());
    }

    @Test
    public void testSpecifySystemClockLong() {
        System.setProperty("log4j.Clock", SystemClock.class.getName());
        Assertions.assertSame(SystemClock.class, ClockFactory.getClock().getClass());
    }

    @Test
    public void testSpecifyCachedClockShort() {
        System.setProperty("log4j.Clock", "CachedClock");
        Assertions.assertSame(CachedClock.class, ClockFactory.getClock().getClass());
    }

    @Test
    public void testSpecifyCachedClockLong() {
        System.setProperty("log4j.Clock", CachedClock.class.getName());
        Assertions.assertSame(CachedClock.class, ClockFactory.getClock().getClass());
    }

    @Test
    public void testSpecifyCoarseCachedClockShort() {
        System.setProperty("log4j.Clock", "CoarseCachedClock");
        Assertions.assertSame(CoarseCachedClock.class, ClockFactory.getClock().getClass());
    }

    @Test
    public void testSpecifyCoarseCachedClockLong() {
        System.setProperty("log4j.Clock", CoarseCachedClock.class.getName());
        Assertions.assertSame(CoarseCachedClock.class, ClockFactory.getClock().getClass());
    }

    @Test
    public void testCustomClock() {
        System.setProperty("log4j.Clock", MyClock.class.getName());
        Assertions.assertSame(MyClock.class, ClockFactory.getClock().getClass());
    }

    public static class MyClock
    implements Clock {
        public long currentTimeMillis() {
            return 42L;
        }
    }
}

