/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import java.util.List;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.junit.LoggerContextSource;
import org.apache.logging.log4j.junit.Named;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

@LoggerContextSource(value="log4j-throwable.xml")
public class ThrowableTest {
    private ListAppender app;
    private Logger logger;

    @BeforeEach
    public void setUp(LoggerContext context, @Named(value="List") ListAppender app) {
        this.logger = context.getLogger("LoggerTest");
        this.app = app.clear();
    }

    @Test
    public void testException() {
        NullPointerException cause = new NullPointerException("null pointer");
        IllegalArgumentException parent = new IllegalArgumentException("IllegalArgument", cause);
        this.logger.error("Exception", (Throwable)parent);
        List<String> msgs = this.app.getMessages();
        Assertions.assertNotNull(msgs);
        Assertions.assertEquals((int)1, (int)msgs.size(), (String)("Incorrect number of messages. Should be 1 is " + msgs.size()));
        Assertions.assertFalse((boolean)msgs.get(0).contains("suppressed"), (String)"No suppressed lines");
    }
}

