/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.pattern.MaxLengthConverter;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.SimpleMessage;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MaxLengthConverterTest {
    private static final MaxLengthConverter converter = MaxLengthConverter.newInstance(null, (String[])new String[]{"%m", "10"});

    @Test
    public void testUnderMaxLength() {
        SimpleMessage message = new SimpleMessage("0123456789");
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName("MyLogger").setLevel(Level.DEBUG).setMessage((Message)message).build();
        StringBuilder sb = new StringBuilder();
        converter.format((LogEvent)event, sb);
        Assertions.assertEquals((Object)"0123456789", (Object)sb.toString());
    }

    @Test
    public void testOverMaxLength() {
        SimpleMessage message = new SimpleMessage("01234567890123456789");
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName("MyLogger").setLevel(Level.DEBUG).setMessage((Message)message).build();
        StringBuilder sb = new StringBuilder();
        converter.format((LogEvent)event, sb);
        Assertions.assertEquals((Object)"0123456789", (Object)sb.toString());
    }

    @Test
    public void testOverMaxLength21WithEllipsis() {
        SimpleMessage message = new SimpleMessage("012345678901234567890123456789");
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName("MyLogger").setLevel(Level.DEBUG).setMessage((Message)message).build();
        StringBuilder sb = new StringBuilder();
        MaxLengthConverter.newInstance(null, (String[])new String[]{"%m", "21"}).format((LogEvent)event, sb);
        Assertions.assertEquals((Object)"012345678901234567890...", (Object)sb.toString());
    }
}

