/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import java.util.List;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.junit.LoggerContextSource;
import org.apache.logging.log4j.junit.Named;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@LoggerContextSource(value="log4j2-calling-class.xml")
public class CallerInformationTest {
    @Test
    public void testClassLogger(LoggerContext context, @Named(value="Class") ListAppender app) {
        app.clear();
        Logger logger = context.getLogger("ClassLogger");
        logger.info("Ignored message contents.");
        logger.warn("Verifying the caller class is still correct.");
        logger.error("Hopefully nobody breaks me!");
        List<String> messages = app.getMessages();
        Assertions.assertEquals((int)3, (int)messages.size(), (String)"Incorrect number of messages.");
        for (String message : messages) {
            Assertions.assertEquals((Object)this.getClass().getName(), (Object)message, (String)"Incorrect caller class name.");
        }
    }

    @Test
    public void testMethodLogger(LoggerContext context, @Named(value="Method") ListAppender app) {
        app.clear();
        Logger logger = context.getLogger("MethodLogger");
        logger.info("More messages.");
        logger.warn("CATASTROPHE INCOMING!");
        logger.error("ZOMBIES!!!");
        logger.fatal("brains~~~");
        logger.info("Itchy. Tasty.");
        List<String> messages = app.getMessages();
        Assertions.assertEquals((int)5, (int)messages.size(), (String)"Incorrect number of messages.");
        for (String message : messages) {
            Assertions.assertEquals((Object)"testMethodLogger", (Object)message, (String)"Incorrect caller method name.");
        }
    }
}

