/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.net.ssl;

import java.io.IOException;
import java.io.OutputStream;
import java.net.UnknownHostException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.logging.log4j.core.net.ssl.KeyStoreConfiguration;
import org.apache.logging.log4j.core.net.ssl.MemoryPasswordProvider;
import org.apache.logging.log4j.core.net.ssl.PasswordProvider;
import org.apache.logging.log4j.core.net.ssl.SslConfiguration;
import org.apache.logging.log4j.core.net.ssl.StoreConfigurationException;
import org.apache.logging.log4j.core.net.ssl.TestConstants;
import org.apache.logging.log4j.core.net.ssl.TrustStoreConfiguration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SslConfigurationTest {
    private static final String TLS_TEST_HOST = "login.yahoo.com";
    private static final int TLS_TEST_PORT = 443;

    public static SslConfiguration createTestSslConfigurationResourcesDeprecated() throws StoreConfigurationException {
        KeyStoreConfiguration ksc = new KeyStoreConfiguration("org/apache/logging/log4j/core/net/ssl/client.log4j2-keystore.jks", TestConstants.KEYSTORE_PWD(), "JKS", null);
        TrustStoreConfiguration tsc = new TrustStoreConfiguration("org/apache/logging/log4j/core/net/ssl/truststore.jks", TestConstants.TRUSTSTORE_PWD(), null, null);
        return SslConfiguration.createSSLConfiguration(null, (KeyStoreConfiguration)ksc, (TrustStoreConfiguration)tsc);
    }

    public static SslConfiguration createTestSslConfigurationResources() throws StoreConfigurationException {
        KeyStoreConfiguration ksc = new KeyStoreConfiguration("org/apache/logging/log4j/core/net/ssl/client.log4j2-keystore.jks", (PasswordProvider)new MemoryPasswordProvider(TestConstants.KEYSTORE_PWD()), "JKS", null);
        TrustStoreConfiguration tsc = new TrustStoreConfiguration("org/apache/logging/log4j/core/net/ssl/truststore.jks", (PasswordProvider)new MemoryPasswordProvider(TestConstants.TRUSTSTORE_PWD()), null, null);
        return SslConfiguration.createSSLConfiguration(null, (KeyStoreConfiguration)ksc, (TrustStoreConfiguration)tsc);
    }

    public static SslConfiguration createTestSslConfigurationFilesDeprecated() throws StoreConfigurationException {
        KeyStoreConfiguration ksc = new KeyStoreConfiguration("src/test/resources/org/apache/logging/log4j/core/net/ssl/client.log4j2-keystore.jks", TestConstants.KEYSTORE_PWD(), "JKS", null);
        TrustStoreConfiguration tsc = new TrustStoreConfiguration("src/test/resources/org/apache/logging/log4j/core/net/ssl/truststore.jks", TestConstants.TRUSTSTORE_PWD(), null, null);
        return SslConfiguration.createSSLConfiguration(null, (KeyStoreConfiguration)ksc, (TrustStoreConfiguration)tsc);
    }

    public static SslConfiguration createTestSslConfigurationFiles() throws StoreConfigurationException {
        KeyStoreConfiguration ksc = new KeyStoreConfiguration("src/test/resources/org/apache/logging/log4j/core/net/ssl/client.log4j2-keystore.jks", (PasswordProvider)new MemoryPasswordProvider(TestConstants.KEYSTORE_PWD()), "JKS", null);
        TrustStoreConfiguration tsc = new TrustStoreConfiguration("src/test/resources/org/apache/logging/log4j/core/net/ssl/truststore.jks", (PasswordProvider)new MemoryPasswordProvider(TestConstants.TRUSTSTORE_PWD()), null, null);
        return SslConfiguration.createSSLConfiguration(null, (KeyStoreConfiguration)ksc, (TrustStoreConfiguration)tsc);
    }

    @Test
    public void testGettersFromScratchFiles() throws StoreConfigurationException {
        Assertions.assertNotNull((Object)SslConfigurationTest.createTestSslConfigurationFiles().getProtocol());
        Assertions.assertNotNull((Object)SslConfigurationTest.createTestSslConfigurationFiles().getKeyStoreConfig());
        Assertions.assertNotNull((Object)SslConfigurationTest.createTestSslConfigurationFiles().getSslContext());
        Assertions.assertNotNull((Object)SslConfigurationTest.createTestSslConfigurationFiles().getSslSocketFactory());
        Assertions.assertNotNull((Object)SslConfigurationTest.createTestSslConfigurationFiles().getTrustStoreConfig());
    }

    @Test
    public void testGettersFromScratchResources() throws StoreConfigurationException {
        Assertions.assertNotNull((Object)SslConfigurationTest.createTestSslConfigurationResources().getProtocol());
        Assertions.assertNotNull((Object)SslConfigurationTest.createTestSslConfigurationResources().getKeyStoreConfig());
        Assertions.assertNotNull((Object)SslConfigurationTest.createTestSslConfigurationResources().getSslContext());
        Assertions.assertNotNull((Object)SslConfigurationTest.createTestSslConfigurationResources().getSslSocketFactory());
        Assertions.assertNotNull((Object)SslConfigurationTest.createTestSslConfigurationResources().getTrustStoreConfig());
    }

    @Test
    public void equals() {
        Assertions.assertEquals((Object)SslConfiguration.createSSLConfiguration(null, null, null), (Object)SslConfiguration.createSSLConfiguration(null, null, null));
    }

    @Test
    public void emptyConfigurationDoesntCauseNullSSLSocketFactory() {
        SslConfiguration sc = SslConfiguration.createSSLConfiguration(null, null, null);
        SSLSocketFactory factory = sc.getSslSocketFactory();
        Assertions.assertNotNull((Object)factory);
    }

    @Test
    public void emptyConfigurationHasDefaultTrustStore() throws IOException {
        SslConfiguration sc = SslConfiguration.createSSLConfiguration(null, null, null);
        SSLSocketFactory factory = sc.getSslSocketFactory();
        try (SSLSocket clientSocket = (SSLSocket)factory.createSocket(TLS_TEST_HOST, 443);){
            Assertions.assertNotNull((Object)clientSocket);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    @Test
    public void connectionFailsWithoutValidServerCertificate() throws IOException, StoreConfigurationException {
        TrustStoreConfiguration tsc = new TrustStoreConfiguration("src/test/resources/org/apache/logging/log4j/core/net/ssl/truststore.jks", (PasswordProvider)new MemoryPasswordProvider(TestConstants.NULL_PWD), null, null);
        SslConfiguration sc = SslConfiguration.createSSLConfiguration(null, null, (TrustStoreConfiguration)tsc);
        SSLSocketFactory factory = sc.getSslSocketFactory();
        try (SSLSocket clientSocket = (SSLSocket)factory.createSocket(TLS_TEST_HOST, 443);
             OutputStream os = clientSocket.getOutputStream();){
            Assertions.assertThrows(IOException.class, () -> os.write("GET config/login_verify2?".getBytes()));
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    @Test
    public void loadKeyStoreWithoutPassword() throws StoreConfigurationException {
        KeyStoreConfiguration ksc = new KeyStoreConfiguration("src/test/resources/org/apache/logging/log4j/core/net/ssl/client.log4j2-keystore.jks", (PasswordProvider)new MemoryPasswordProvider(TestConstants.NULL_PWD), null, null);
        SslConfiguration sslConf = SslConfiguration.createSSLConfiguration(null, (KeyStoreConfiguration)ksc, null);
        SSLSocketFactory factory = sslConf.getSslSocketFactory();
        Assertions.assertNotNull((Object)factory);
    }
}

