/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.lookup;

import java.util.HashMap;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.lookup.Interpolator;
import org.apache.logging.log4j.core.lookup.MapLookup;
import org.apache.logging.log4j.core.lookup.StrLookup;
import org.apache.logging.log4j.core.lookup.StrSubstitutor;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class StrSubstitutorTest {
    private static final String TESTKEY = "TestKey";
    private static final String TESTVAL = "TestValue";

    @BeforeAll
    public static void before() {
        System.setProperty(TESTKEY, TESTVAL);
    }

    @AfterAll
    public static void after() {
        System.clearProperty(TESTKEY);
    }

    @Test
    public void testLookup() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(TESTKEY, TESTVAL);
        Interpolator lookup = new Interpolator((StrLookup)new MapLookup(map));
        StrSubstitutor subst = new StrSubstitutor((StrLookup)lookup);
        ThreadContext.put((String)TESTKEY, (String)TESTVAL);
        String value = subst.replace("${TestKey}-${ctx:TestKey}-${sys:TestKey}");
        Assertions.assertEquals((Object)"TestValue-TestValue-TestValue", (Object)value);
        value = subst.replace("${BadKey}");
        Assertions.assertEquals((Object)"${BadKey}", (Object)value);
        value = subst.replace("${BadKey:-Unknown}-${ctx:BadKey:-Unknown}-${sys:BadKey:-Unknown}");
        Assertions.assertEquals((Object)"Unknown-Unknown-Unknown", (Object)value);
        value = subst.replace("${BadKey:-Unknown}-${ctx:BadKey}-${sys:BadKey:-Unknown}");
        Assertions.assertEquals((Object)"Unknown-${ctx:BadKey}-Unknown", (Object)value);
        value = subst.replace("${BadKey:-Unknown}-${ctx:BadKey:-}-${sys:BadKey:-Unknown}");
        Assertions.assertEquals((Object)"Unknown--Unknown", (Object)value);
    }

    @Test
    public void testDefault() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(TESTKEY, TESTVAL);
        Interpolator lookup = new Interpolator((StrLookup)new MapLookup(map));
        StrSubstitutor subst = new StrSubstitutor((StrLookup)lookup);
        ThreadContext.put((String)TESTKEY, (String)TESTVAL);
        String value = subst.replace("${sys:TestKey1:-${ctx:TestKey}}");
        Assertions.assertEquals((Object)TESTVAL, (Object)value);
    }
}

