/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.lookup;

import java.util.HashMap;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.lookup.MainMapLookup;
import org.apache.logging.log4j.core.lookup.MapLookup;
import org.apache.logging.log4j.message.MapMessage;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.StringMapMessage;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MapLookupTest {
    @Test
    public void testEmptyMap() {
        MapLookup lookup = new MapLookup(new HashMap());
        Assertions.assertNull((Object)lookup.lookup(null));
        Assertions.assertNull((Object)lookup.lookup("X"));
    }

    @Test
    public void testMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("A", "B");
        MapLookup lookup = new MapLookup(map);
        Assertions.assertNull((Object)lookup.lookup(null));
        Assertions.assertEquals((Object)"B", (Object)lookup.lookup("A"));
    }

    @Test
    public void testNullMap() {
        MapLookup lookup = new MapLookup();
        Assertions.assertNull((Object)lookup.lookup(null));
        Assertions.assertNull((Object)lookup.lookup("X"));
    }

    @Test
    public void testMainMap() {
        MainMapLookup.setMainArguments((String[])new String[]{"--file", "foo.txt"});
        MapLookup lookup = MainMapLookup.MAIN_SINGLETON;
        Assertions.assertNull((Object)lookup.lookup(null));
        Assertions.assertNull((Object)lookup.lookup("X"));
        Assertions.assertEquals((Object)"--file", (Object)lookup.lookup("0"));
        Assertions.assertEquals((Object)"foo.txt", (Object)lookup.lookup("1"));
        Assertions.assertEquals((Object)"foo.txt", (Object)lookup.lookup("--file"));
        Assertions.assertNull((Object)lookup.lookup("foo.txt"));
    }

    @Test
    public void testEventStringMapMessage() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("A", "B");
        HashMap<String, String> eventMap = new HashMap<String, String>();
        eventMap.put("A1", "B1");
        StringMapMessage message = new StringMapMessage(eventMap);
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setMessage((Message)message).build();
        MapLookup lookup = new MapLookup(map);
        Assertions.assertEquals((Object)"B", (Object)lookup.lookup((LogEvent)event, "A"));
        Assertions.assertEquals((Object)"B1", (Object)lookup.lookup((LogEvent)event, "A1"));
    }

    @Test
    public void testEventMapMessage() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("A", "B");
        HashMap<String, Integer> eventMap = new HashMap<String, Integer>();
        eventMap.put("A1", 11);
        MapMessage message = new MapMessage(eventMap);
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setMessage((Message)message).build();
        MapLookup lookup = new MapLookup(map);
        Assertions.assertEquals((Object)"B", (Object)lookup.lookup((LogEvent)event, "A"));
        Assertions.assertEquals((Object)"11", (Object)lookup.lookup((LogEvent)event, "A1"));
    }

    @Test
    public void testLookupDefaultMapIsCheckedBeforeMapMessage() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("A", "ADefault");
        HashMap<String, String> eventMap = new HashMap<String, String>();
        eventMap.put("A", "AEvent");
        MapMessage message = new MapMessage(eventMap);
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setMessage((Message)message).build();
        MapLookup lookup = new MapLookup(map);
        Assertions.assertEquals((Object)"ADefault", (Object)lookup.lookup((LogEvent)event, "A"));
    }

    @Test
    public void testNullEvent() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("A", "B");
        MapLookup lookup = new MapLookup(map);
        Assertions.assertEquals((Object)"B", (Object)lookup.lookup(null, "A"));
    }
}

