/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.layout;

import java.util.List;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.lookup.MainMapLookup;
import org.apache.logging.log4j.junit.LoggerContextSource;
import org.apache.logging.log4j.junit.Named;
import org.apache.logging.log4j.junit.ReconfigurationPolicy;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@LoggerContextSource(value="log4j2-962.xml", reconfigure=ReconfigurationPolicy.BEFORE_EACH)
public class PatternLayoutMainMapLookupTest {
    @Test
    public void testFileName(@Named(value="File") FileAppender fileApp) {
        String name = fileApp.getFileName();
        Assertions.assertEquals((Object)"target/value0.log", (Object)name);
    }

    @Test
    public void testHeader(LoggerContext context, @Named(value="List") ListAppender listApp) {
        ExtendedLogger logger = context.getLogger(this.getClass());
        logger.info("Hello World");
        List<String> initialMessages = listApp.getMessages();
        Assertions.assertFalse((boolean)initialMessages.isEmpty());
        String messagesStr = initialMessages.toString();
        Assertions.assertEquals((Object)"Header: value0", (Object)initialMessages.get(0), (String)messagesStr);
        listApp.stop();
        List<String> finalMessages = listApp.getMessages();
        Assertions.assertEquals((int)3, (int)finalMessages.size());
        Assertions.assertEquals((Object)"Footer: value1", (Object)finalMessages.get(2));
        listApp.clear();
    }

    static {
        MainMapLookup.setMainArguments((String[])new String[]{"value0", "value1", "value2"});
    }
}

