/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.layout;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Stream;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.junit.LoggerContextSource;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="concurrency")
public class ConcurrentLoggingWithGelfLayoutTest {
    private static final Path PATH = Paths.get("target", "test-gelf-layout.log");

    @AfterAll
    static void after() throws IOException {
        Files.deleteIfExists(PATH);
    }

    @Test
    @LoggerContextSource(value="log4j2-gelf-layout.xml")
    public void testConcurrentLogging(LoggerContext context) throws Throwable {
        ExtendedLogger log = context.getLogger(ConcurrentLoggingWithGelfLayoutTest.class);
        int threadCount = Runtime.getRuntime().availableProcessors() * 2;
        CountDownLatch latch = new CountDownLatch(threadCount);
        List thrown = Collections.synchronizedList(new ArrayList());
        for (int x = 0; x < threadCount; ++x) {
            Thread t = new Thread(() -> ConcurrentLoggingWithGelfLayoutTest.lambda$testConcurrentLogging$0((Logger)log, latch));
            t.setUncaughtExceptionHandler((t1, e) -> thrown.add(e));
            t.start();
        }
        latch.await();
        if (!thrown.isEmpty()) {
            throw (Throwable)thrown.get(0);
        }
        if (Files.exists(PATH, new LinkOption[0])) {
            try (Stream<String> lines = Files.lines(PATH, Charset.defaultCharset());){
                lines.forEach(line -> MatcherAssert.assertThat((Object)line, (Matcher)CoreMatchers.both((Matcher)CoreMatchers.startsWith((String)"{\"version\":\"1.1\",\"host\":\"myself\",\"timestamp\":")).and(CoreMatchers.endsWith((String)"\"}"))));
            }
        }
    }

    private static /* synthetic */ void lambda$testConcurrentLogging$0(Logger log, CountDownLatch latch) {
        log.info((Object)latch.getCount());
        try {
            for (int i = 0; i < 64; ++i) {
                log.info("First message.");
                log.info("Second message.");
            }
        }
        finally {
            latch.countDown();
        }
    }
}

