/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.jackson;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import org.apache.logging.log4j.categories.Layouts;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={Layouts.Json.class})
public class JacksonIssue429MyNamesTest {
    private static final ObjectMapper SHARED_MAPPER = new ObjectMapper();
    private final ObjectMapper MAPPER = this.objectMapper();

    protected String aposToQuotes(String json) {
        return json.replace("'", "\"");
    }

    protected ObjectMapper objectMapper() {
        return SHARED_MAPPER;
    }

    @Test
    public void testStackTraceElementWithCustom() throws Exception {
        StackTraceBean bean = (StackTraceBean)this.MAPPER.readValue(this.aposToQuotes("{'Location':{'class':'package.SomeClass','method':'someMethod','file':'SomeClass.java','line':13}}"), StackTraceBean.class);
        Assert.assertNotNull((Object)bean);
        Assert.assertNotNull((Object)bean.location);
        Assert.assertEquals((long)13L, (long)bean.location.getLineNumber());
        ObjectMapper mapper = new ObjectMapper();
        SimpleModule module = new SimpleModule();
        module.addDeserializer(StackTraceElement.class, (JsonDeserializer)new MyStackTraceElementDeserializer());
        mapper.registerModule((Module)module);
        StackTraceElement elem = (StackTraceElement)mapper.readValue(this.aposToQuotes("{'class':'package.SomeClass','method':'someMethod','file':'SomeClass.java','line':13}"), StackTraceElement.class);
        Assert.assertNotNull((Object)elem);
        Assert.assertEquals((long)13L, (long)elem.getLineNumber());
    }

    static class StackTraceBean {
        public static final int NUM = 13;
        @JsonProperty(value="Location")
        @JsonDeserialize(using=MyStackTraceElementDeserializer.class)
        private StackTraceElement location;

        StackTraceBean() {
        }
    }

    static class MyStackTraceElementDeserializer
    extends StdScalarDeserializer<StackTraceElement> {
        private static final long serialVersionUID = 1L;
        public static final MyStackTraceElementDeserializer instance = new MyStackTraceElementDeserializer();

        public MyStackTraceElementDeserializer() {
            super(StackTraceElement.class);
        }

        public StackTraceElement deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonToken t = jp.getCurrentToken();
            if (t == JsonToken.START_OBJECT) {
                String className = "";
                String methodName = "";
                String fileName = "";
                int lineNumber = -1;
                while ((t = jp.nextValue()) != JsonToken.END_OBJECT) {
                    String propName = jp.getCurrentName();
                    if ("class".equals(propName)) {
                        className = jp.getText();
                        continue;
                    }
                    if ("file".equals(propName)) {
                        fileName = jp.getText();
                        continue;
                    }
                    if ("line".equals(propName)) {
                        if (t.isNumeric()) {
                            lineNumber = jp.getIntValue();
                            continue;
                        }
                        throw JsonMappingException.from((JsonParser)jp, (String)("Non-numeric token (" + t + ") for property 'lineNumber'"));
                    }
                    if ("method".equals(propName)) {
                        methodName = jp.getText();
                        continue;
                    }
                    if ("nativeMethod".equals(propName)) continue;
                    this.handleUnknownProperty(jp, ctxt, this._valueClass, propName);
                }
                return new StackTraceElement(className, methodName, fileName, lineNumber);
            }
            throw ctxt.mappingException(this._valueClass, t);
        }
    }
}

