/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.filter;

import java.util.List;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.filter.BurstFilter;
import org.apache.logging.log4j.junit.LoggerContextSource;
import org.apache.logging.log4j.junit.Named;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@LoggerContextSource(value="log4j-burst.xml")
public class BurstFilterTest {
    private final ListAppender app;
    private final BurstFilter filter;
    private final Logger logger;

    public BurstFilterTest(LoggerContext context, @Named(value="ListAppender") ListAppender app) {
        this.app = app;
        this.filter = (BurstFilter)app.getFilter();
        Assertions.assertNotNull((Object)this.filter);
        this.logger = context.getLogger(this.getClass());
    }

    @Test
    public void test() throws Exception {
        int i;
        System.nanoTime();
        for (int i2 = 0; i2 < 110; ++i2) {
            if (i2 % 10 == 0) {
                Thread.sleep(200L);
            }
            this.logger.info("Logging 110 messages, should only see 100 logs # " + (i2 + 1));
            Assertions.assertTrue((this.filter.getAvailable() < 100 ? 1 : 0) != 0, (String)"Incorrect number of available slots");
        }
        List<String> msgs = this.app.getMessages();
        Assertions.assertEquals((int)100, (int)msgs.size(), (String)("Incorrect message count. Should be 100, actual " + msgs.size()));
        this.app.clear();
        Assertions.assertTrue((this.filter.getAvailable() < 100 ? 1 : 0) != 0, (String)"Incorrect number of available slots");
        Thread.sleep(1500L);
        for (i = 0; i < 110; ++i) {
            this.logger.info("Waited 1.5 seconds and trying to log again, should see more than 0 and less than 100" + (i + 1));
        }
        msgs = this.app.getMessages();
        Assertions.assertFalse((boolean)msgs.isEmpty(), (String)"No messages were counted.");
        Assertions.assertTrue((msgs.size() < 100 ? 1 : 0) != 0, (String)("Incorrect message count. Should be > 0 and < 100, actual " + msgs.size()));
        this.app.clear();
        this.filter.clear();
        for (i = 0; i < 110; ++i) {
            this.logger.info("Waited 1.5 seconds and trying to log again, should see more than 0 and less than 100" + (i + 1));
        }
        Assertions.assertEquals((int)0, (int)this.filter.getAvailable(), (String)"");
        this.app.clear();
        for (i = 0; i < 110; ++i) {
            this.logger.debug("TEST FAILED! Logging 110 debug messages, shouldn't see any of them because they are debugs #" + (i + 1));
        }
        msgs = this.app.getMessages();
        Assertions.assertTrue((boolean)msgs.isEmpty(), (String)("Incorrect message count. Should be 0, actual " + msgs.size()));
        this.app.clear();
        for (i = 0; i < 110; ++i) {
            this.logger.warn("Logging 110 warn messages, should see all of them because they are warns #" + (i + 1));
        }
        msgs = this.app.getMessages();
        Assertions.assertEquals((int)110, (int)msgs.size(), (String)("Incorrect message count. Should be 110, actual " + msgs.size()));
        this.app.clear();
        for (i = 0; i < 110; ++i) {
            this.logger.error("Logging 110 error messages, should see all of them because they are errors #" + (i + 1));
        }
        msgs = this.app.getMessages();
        Assertions.assertEquals((int)110, (int)msgs.size(), (String)("Incorrect message count. Should be 110, actual " + msgs.size()));
        this.app.clear();
        for (i = 0; i < 110; ++i) {
            this.logger.fatal("Logging 110 fatal messages, should see all of them because they are fatals #" + (i + 1));
        }
        msgs = this.app.getMessages();
        Assertions.assertEquals((int)110, (int)msgs.size(), (String)("Incorrect message count. Should be 110, actual " + msgs.size()));
        this.app.clear();
        Thread.sleep(3100L);
        for (i = 0; i < 110; ++i) {
            this.logger.debug("Waited 3+ seconds, should see 100 logs #" + (i + 1));
        }
        msgs = this.app.getMessages();
        Assertions.assertEquals((int)100, (int)msgs.size(), (String)("Incorrect message count. Should be 100, actual " + msgs.size()));
        this.app.clear();
    }
}

