/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.filter;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.apache.logging.log4j.core.filter.AbstractFilterable;
import org.apache.logging.log4j.core.filter.CompositeFilter;
import org.apache.logging.log4j.core.filter.ThresholdFilter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class AbstractFilterableTest {
    MockedAbstractFilterable filterable;

    @BeforeEach
    public void setup() {
        this.filterable = new MockedAbstractFilterable();
    }

    @Test
    public void testAddSimpleFilter() throws Exception {
        ThresholdFilter filter = ThresholdFilter.createFilter((Level)Level.ERROR, null, null);
        this.filterable.addFilter((Filter)filter);
        Assertions.assertSame((Object)filter, (Object)this.filterable.getFilter());
    }

    @Test
    public void testAddMultipleSimpleFilters() throws Exception {
        ThresholdFilter filter = ThresholdFilter.createFilter((Level)Level.ERROR, null, null);
        this.filterable.addFilter((Filter)filter);
        Assertions.assertSame((Object)filter, (Object)this.filterable.getFilter());
        this.filterable.addFilter((Filter)filter);
        Assertions.assertTrue((boolean)(this.filterable.getFilter() instanceof CompositeFilter));
        Assertions.assertEquals((int)2, (int)((CompositeFilter)this.filterable.getFilter()).getFilters().size());
    }

    @Test
    public void testAddMultipleEqualSimpleFilter() throws Exception {
        EqualFilter filter = new EqualFilter("test");
        this.filterable.addFilter((Filter)filter);
        Assertions.assertSame((Object)((Object)filter), (Object)this.filterable.getFilter());
        this.filterable.addFilter((Filter)filter);
        Assertions.assertTrue((boolean)(this.filterable.getFilter() instanceof CompositeFilter));
        Assertions.assertEquals((int)2, (int)((CompositeFilter)this.filterable.getFilter()).getFilters().size());
    }

    @Test
    public void testAddCompositeFilter() throws Exception {
        ThresholdFilter filter1 = ThresholdFilter.createFilter((Level)Level.ERROR, null, null);
        ThresholdFilter filter2 = ThresholdFilter.createFilter((Level)Level.ERROR, null, null);
        CompositeFilter compositeFilter = CompositeFilter.createFilters((Filter[])new Filter[]{filter1, filter2});
        this.filterable.addFilter((Filter)compositeFilter);
        Assertions.assertSame((Object)compositeFilter, (Object)this.filterable.getFilter());
    }

    @Test
    public void testAddMultipleCompositeFilters() throws Exception {
        ThresholdFilter filter1 = ThresholdFilter.createFilter((Level)Level.ERROR, null, null);
        ThresholdFilter filter2 = ThresholdFilter.createFilter((Level)Level.ERROR, null, null);
        ThresholdFilter filter3 = ThresholdFilter.createFilter((Level)Level.ERROR, null, null);
        CompositeFilter compositeFilter = CompositeFilter.createFilters((Filter[])new Filter[]{filter1, filter2, filter3});
        this.filterable.addFilter((Filter)compositeFilter);
        Assertions.assertSame((Object)compositeFilter, (Object)this.filterable.getFilter());
        this.filterable.addFilter((Filter)compositeFilter);
        Assertions.assertTrue((boolean)(this.filterable.getFilter() instanceof CompositeFilter));
        Assertions.assertEquals((int)6, (int)((CompositeFilter)this.filterable.getFilter()).getFilters().size());
    }

    @Test
    public void testAddSimpleFilterAndCompositeFilter() throws Exception {
        ThresholdFilter filter1 = ThresholdFilter.createFilter((Level)Level.ERROR, null, null);
        ThresholdFilter filter2 = ThresholdFilter.createFilter((Level)Level.ERROR, null, null);
        ThresholdFilter notInCompositeFilterFilter = ThresholdFilter.createFilter((Level)Level.ERROR, null, null);
        CompositeFilter compositeFilter = CompositeFilter.createFilters((Filter[])new Filter[]{filter1, filter2});
        this.filterable.addFilter((Filter)notInCompositeFilterFilter);
        Assertions.assertSame((Object)notInCompositeFilterFilter, (Object)this.filterable.getFilter());
        this.filterable.addFilter((Filter)compositeFilter);
        Assertions.assertTrue((boolean)(this.filterable.getFilter() instanceof CompositeFilter));
        Assertions.assertEquals((int)2, (int)((CompositeFilter)this.filterable.getFilter()).getFilters().size());
    }

    @Test
    public void testAddCompositeFilterAndSimpleFilter() throws Exception {
        ThresholdFilter filter1 = ThresholdFilter.createFilter((Level)Level.ERROR, null, null);
        ThresholdFilter filter2 = ThresholdFilter.createFilter((Level)Level.ERROR, null, null);
        ThresholdFilter notInCompositeFilterFilter = ThresholdFilter.createFilter((Level)Level.ERROR, null, null);
        CompositeFilter compositeFilter = CompositeFilter.createFilters((Filter[])new Filter[]{filter1, filter2});
        this.filterable.addFilter((Filter)compositeFilter);
        Assertions.assertSame((Object)compositeFilter, (Object)this.filterable.getFilter());
        this.filterable.addFilter((Filter)notInCompositeFilterFilter);
        Assertions.assertTrue((boolean)(this.filterable.getFilter() instanceof CompositeFilter));
        Assertions.assertEquals((int)3, (int)((CompositeFilter)this.filterable.getFilter()).getFilters().size());
    }

    @Test
    public void testRemoveSimpleFilterFromSimpleFilter() throws Exception {
        ThresholdFilter filter = ThresholdFilter.createFilter((Level)Level.ERROR, null, null);
        this.filterable.addFilter((Filter)filter);
        this.filterable.removeFilter((Filter)filter);
        Assertions.assertNull((Object)this.filterable.getFilter());
    }

    @Test
    public void testRemoveSimpleEqualFilterFromSimpleFilter() throws Exception {
        EqualFilter filterOriginal = new EqualFilter("test");
        EqualFilter filterCopy = new EqualFilter("test");
        this.filterable.addFilter((Filter)filterOriginal);
        this.filterable.removeFilter((Filter)filterCopy);
        Assertions.assertNull((Object)this.filterable.getFilter());
    }

    @Test
    public void testRemoveSimpleEqualFilterFromTwoSimpleFilters() throws Exception {
        EqualFilter filterOriginal = new EqualFilter("test");
        EqualFilter filterCopy = new EqualFilter("test");
        this.filterable.addFilter((Filter)filterOriginal);
        this.filterable.addFilter((Filter)filterOriginal);
        this.filterable.removeFilter((Filter)filterCopy);
        Assertions.assertSame((Object)((Object)filterOriginal), (Object)this.filterable.getFilter());
        this.filterable.removeFilter((Filter)filterCopy);
        Assertions.assertNull((Object)this.filterable.getFilter());
    }

    @Test
    public void testRemoveSimpleEqualFilterFromMultipleSimpleFilters() throws Exception {
        EqualFilter filterOriginal = new EqualFilter("test");
        EqualFilter filterCopy = new EqualFilter("test");
        this.filterable.addFilter((Filter)filterOriginal);
        this.filterable.addFilter((Filter)filterOriginal);
        this.filterable.addFilter((Filter)filterCopy);
        this.filterable.removeFilter((Filter)filterCopy);
        Assertions.assertTrue((boolean)(this.filterable.getFilter() instanceof CompositeFilter));
        Assertions.assertEquals((int)2, (int)((CompositeFilter)this.filterable.getFilter()).getFilters().size());
        this.filterable.removeFilter((Filter)filterCopy);
        Assertions.assertEquals((Object)((Object)filterOriginal), (Object)this.filterable.getFilter());
        this.filterable.removeFilter((Filter)filterOriginal);
        Assertions.assertNull((Object)this.filterable.getFilter());
    }

    @Test
    public void testRemoveNullFromSingleSimpleFilter() throws Exception {
        ThresholdFilter filter = ThresholdFilter.createFilter((Level)Level.ERROR, null, null);
        this.filterable.addFilter((Filter)filter);
        this.filterable.removeFilter(null);
        Assertions.assertSame((Object)filter, (Object)this.filterable.getFilter());
    }

    @Test
    public void testRemoveNonExistingFilterFromSingleSimpleFilter() throws Exception {
        ThresholdFilter filter = ThresholdFilter.createFilter((Level)Level.ERROR, null, null);
        ThresholdFilter newFilter = ThresholdFilter.createFilter((Level)Level.WARN, null, null);
        this.filterable.addFilter((Filter)filter);
        this.filterable.removeFilter((Filter)newFilter);
        Assertions.assertSame((Object)filter, (Object)this.filterable.getFilter());
    }

    @Test
    public void testRemoveSimpleFilterFromCompositeFilter() {
        ThresholdFilter filter1 = ThresholdFilter.createFilter((Level)Level.ERROR, null, null);
        ThresholdFilter filter2 = ThresholdFilter.createFilter((Level)Level.ERROR, null, null);
        CompositeFilter compositeFilter = CompositeFilter.createFilters((Filter[])new Filter[]{filter1, filter2});
        this.filterable.addFilter((Filter)compositeFilter);
        this.filterable.removeFilter((Filter)filter1);
        Assertions.assertFalse((boolean)(this.filterable.getFilter() instanceof CompositeFilter));
        Assertions.assertEquals((Object)filter2, (Object)this.filterable.getFilter());
    }

    @Test
    public void testRemoveSimpleFilterFromCompositeAndSimpleFilter() {
        ThresholdFilter filter1 = ThresholdFilter.createFilter((Level)Level.ERROR, null, null);
        ThresholdFilter filter2 = ThresholdFilter.createFilter((Level)Level.ERROR, null, null);
        CompositeFilter compositeFilter = CompositeFilter.createFilters((Filter[])new Filter[]{filter1, filter2});
        ThresholdFilter anotherFilter = ThresholdFilter.createFilter((Level)Level.WARN, null, null);
        this.filterable.addFilter((Filter)compositeFilter);
        this.filterable.addFilter((Filter)anotherFilter);
        this.filterable.removeFilter((Filter)anotherFilter);
        Assertions.assertTrue((boolean)(this.filterable.getFilter() instanceof CompositeFilter));
        Assertions.assertEquals((int)2, (int)((CompositeFilter)this.filterable.getFilter()).getFilters().size());
    }

    @Test
    public void testRemoveCompositeFilterFromCompositeFilter() {
        ThresholdFilter filter1 = ThresholdFilter.createFilter((Level)Level.ERROR, null, null);
        ThresholdFilter filter2 = ThresholdFilter.createFilter((Level)Level.ERROR, null, null);
        CompositeFilter compositeFilter = CompositeFilter.createFilters((Filter[])new Filter[]{filter1, filter2});
        this.filterable.addFilter((Filter)compositeFilter);
        this.filterable.removeFilter((Filter)compositeFilter);
        Assertions.assertNull((Object)this.filterable.getFilter());
    }

    @Test
    public void testRemoveFiltersFromComposite() {
        ThresholdFilter filter1 = ThresholdFilter.createFilter((Level)Level.ERROR, null, null);
        ThresholdFilter filter2 = ThresholdFilter.createFilter((Level)Level.ERROR, null, null);
        CompositeFilter compositeFilter = CompositeFilter.createFilters((Filter[])new Filter[]{filter1, filter2});
        ThresholdFilter anotherFilter = ThresholdFilter.createFilter((Level)Level.WARN, null, null);
        this.filterable.addFilter((Filter)compositeFilter);
        this.filterable.addFilter((Filter)anotherFilter);
        Assertions.assertEquals((int)3, (int)((CompositeFilter)this.filterable.getFilter()).getFilters().size());
        this.filterable.removeFilter((Filter)filter1);
        Assertions.assertEquals((int)2, (int)((CompositeFilter)this.filterable.getFilter()).getFilters().size());
        this.filterable.removeFilter((Filter)filter2);
        Assertions.assertSame((Object)anotherFilter, (Object)this.filterable.getFilter());
    }

    private static class EqualFilter
    extends AbstractFilter {
        private final String key;

        public EqualFilter(String key) {
            this.key = key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof EqualFilter)) {
                return false;
            }
            EqualFilter that = (EqualFilter)((Object)o);
            return !(this.key != null ? !this.key.equals(that.key) : that.key != null);
        }

        public int hashCode() {
            return this.key != null ? this.key.hashCode() : 0;
        }
    }

    private static class MockedAbstractFilterable
    extends AbstractFilterable {
        private MockedAbstractFilterable() {
        }
    }
}

