/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config.xml;

import java.util.List;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.xml.XmlConfiguration;
import org.apache.logging.log4j.junit.LoggerContextSource;
import org.apache.logging.log4j.junit.Named;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class XmlLoggerPropsTest {
    @BeforeAll
    static void setupClass() {
        System.setProperty("test", "test");
    }

    @AfterAll
    static void tearDownClass() {
        System.clearProperty("test");
    }

    @Test
    @LoggerContextSource(value="log4j-loggerprops.xml")
    public void testWithProps(LoggerContext context, @Named(value="List") ListAppender listAppender) {
        MatcherAssert.assertThat((Object)context.getConfiguration(), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(XmlConfiguration.class)));
        context.getLogger(this.getClass()).debug("Test with props");
        context.getLogger("tiny.bubbles").debug("Test on root");
        List<String> events = listAppender.getMessages();
        listAppender.clear();
        MatcherAssert.assertThat(events, (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)events.get(0), (Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.containsString((String)"user="), Matchers.containsString((String)"phrasex=****"), Matchers.containsString((String)"test=test"), Matchers.containsString((String)"test2=test2default"), Matchers.containsString((String)"test3=Unknown"), Matchers.containsString((String)"test4=test"), Matchers.containsString((String)"test5=test"), Matchers.containsString((String)"attribKey=attribValue"), Matchers.containsString((String)"duplicateKey=nodeValue")}));
        MatcherAssert.assertThat((Object)events.get(1), (Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.containsString((String)"user="), Matchers.containsString((String)"phrasex=****"), Matchers.containsString((String)"test=test"), Matchers.containsString((String)"test2=test2default"), Matchers.containsString((String)"test3=Unknown"), Matchers.containsString((String)"test4=test"), Matchers.containsString((String)"test5=test"), Matchers.containsString((String)"attribKey=attribValue"), Matchers.containsString((String)"duplicateKey=nodeValue")}));
    }
}

