/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config.plugins.validation.validators;

import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Node;
import org.apache.logging.log4j.core.config.NullConfiguration;
import org.apache.logging.log4j.core.config.plugins.util.PluginBuilder;
import org.apache.logging.log4j.core.config.plugins.util.PluginManager;
import org.apache.logging.log4j.core.config.plugins.util.PluginType;
import org.apache.logging.log4j.core.config.plugins.validation.HostAndPort;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ValidPortValidatorTest {
    private PluginType<HostAndPort> plugin;
    private Node node;

    @BeforeEach
    public void setUp() throws Exception {
        PluginManager manager = new PluginManager("Test");
        manager.collectPlugins();
        this.plugin = manager.getPluginType("HostAndPort");
        Assertions.assertNotNull(this.plugin, (String)"Rebuild this module to ensure annotation processing has been done.");
        this.node = new Node(null, "HostAndPort", this.plugin);
        this.node.getAttributes().put("host", "localhost");
    }

    @Test
    public void testNegativePort() throws Exception {
        this.node.getAttributes().put("port", "-1");
        Assertions.assertNull((Object)this.buildPlugin());
    }

    @Test
    public void testValidPort() throws Exception {
        this.node.getAttributes().put("port", "10");
        Assertions.assertNotNull((Object)this.buildPlugin());
    }

    @Test
    public void testInvalidPort() throws Exception {
        this.node.getAttributes().put("port", "1234567890");
        Assertions.assertNull((Object)this.buildPlugin());
    }

    private HostAndPort buildPlugin() {
        return (HostAndPort)new PluginBuilder(this.plugin).withConfiguration((Configuration)new NullConfiguration()).withConfigurationNode(this.node).build();
    }
}

