/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config.plugins.validation.validators;

import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Node;
import org.apache.logging.log4j.core.config.NullConfiguration;
import org.apache.logging.log4j.core.config.plugins.util.PluginBuilder;
import org.apache.logging.log4j.core.config.plugins.util.PluginManager;
import org.apache.logging.log4j.core.config.plugins.util.PluginType;
import org.apache.logging.log4j.core.config.plugins.validation.HostAndPort;
import org.apache.logging.log4j.junit.StatusLoggerLevel;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

@StatusLoggerLevel(value="FATAL")
public class ValidHostValidatorTest {
    private PluginType<HostAndPort> plugin;
    private Node node;

    @BeforeEach
    public void setUp() throws Exception {
        PluginManager manager = new PluginManager("Test");
        manager.collectPlugins();
        this.plugin = manager.getPluginType("HostAndPort");
        Assertions.assertNotNull(this.plugin, (String)"Rebuild this module to ensure annotation processing has been done.");
        this.node = new Node(null, "HostAndPort", this.plugin);
    }

    @Test
    public void testNullHost() throws Exception {
        Assertions.assertNull((Object)this.buildPlugin());
    }

    @Test
    public void testInvalidIpAddress() throws Exception {
        this.node.getAttributes().put("host", "256.256.256.256");
        this.node.getAttributes().put("port", "1");
        HostAndPort plugin = this.buildPlugin();
        Assertions.assertNull((Object)plugin, (String)("Expected null, but got: " + plugin));
    }

    @Test
    public void testLocalhost() throws Exception {
        this.node.getAttributes().put("host", "localhost");
        this.node.getAttributes().put("port", "1");
        HostAndPort hostAndPort = this.buildPlugin();
        Assertions.assertNotNull((Object)hostAndPort);
        Assertions.assertTrue((boolean)hostAndPort.isValid());
    }

    private HostAndPort buildPlugin() {
        return (HostAndPort)new PluginBuilder(this.plugin).withConfiguration((Configuration)new NullConfiguration()).withConfigurationNode(this.node).build();
    }
}

