/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config.builder;

import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LifeCycle;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.appender.mom.kafka.KafkaAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.CustomLevelConfig;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.config.builder.CustomConfigurationFactory;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilderFactory;
import org.apache.logging.log4j.core.config.builder.impl.BuiltConfiguration;
import org.apache.logging.log4j.core.filter.ThresholdFilter;
import org.apache.logging.log4j.core.layout.GelfLayout;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ConfigurationAssemblerTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBuildConfiguration() throws Exception {
        try {
            System.setProperty("Log4jContextSelector", "org.apache.logging.log4j.core.async.AsyncLoggerContextSelector");
            ConfigurationBuilder builder = ConfigurationBuilderFactory.newConfigurationBuilder();
            CustomConfigurationFactory.addTestFixtures("config name", (ConfigurationBuilder<BuiltConfiguration>)builder);
            Configuration configuration = (Configuration)builder.build();
            try (LoggerContext ctx = Configurator.initialize((Configuration)configuration);){
                this.validate(configuration);
            }
        }
        finally {
            System.getProperties().remove("Log4jContextSelector");
        }
    }

    @Test
    public void testCustomConfigurationFactory() throws Exception {
        try {
            System.setProperty("log4j.configurationFactory", "org.apache.logging.log4j.core.config.builder.CustomConfigurationFactory");
            System.setProperty("Log4jContextSelector", "org.apache.logging.log4j.core.async.AsyncLoggerContextSelector");
            Configuration config = ((LoggerContext)LogManager.getContext((boolean)false)).getConfiguration();
            this.validate(config);
        }
        finally {
            System.getProperties().remove("Log4jContextSelector");
            System.getProperties().remove("log4j.configurationFactory");
        }
    }

    private void validate(Configuration config) {
        Assertions.assertNotNull((Object)config);
        Assertions.assertNotNull((Object)config.getName());
        Assertions.assertFalse((boolean)config.getName().isEmpty());
        Assertions.assertNotNull((Object)config, (String)"No configuration created");
        Assertions.assertEquals((Object)config.getState(), (Object)LifeCycle.State.STARTED, (String)("Incorrect State: " + config.getState()));
        Map appenders = config.getAppenders();
        Assertions.assertNotNull((Object)appenders);
        Assertions.assertEquals((int)appenders.size(), (int)2, (String)("Incorrect number of Appenders: " + appenders.size()));
        KafkaAppender kafkaAppender = (KafkaAppender)appenders.get("Kafka");
        GelfLayout gelfLayout = (GelfLayout)kafkaAppender.getLayout();
        ConsoleAppender consoleAppender = (ConsoleAppender)appenders.get("Stdout");
        PatternLayout patternLayout = (PatternLayout)consoleAppender.getLayout();
        Map loggers = config.getLoggers();
        Assertions.assertNotNull((Object)loggers);
        Assertions.assertEquals((int)loggers.size(), (int)2, (String)("Incorrect number of LoggerConfigs: " + loggers.size()));
        LoggerConfig rootLoggerConfig = (LoggerConfig)loggers.get("");
        Assertions.assertEquals((Object)Level.ERROR, (Object)rootLoggerConfig.getLevel());
        Assertions.assertFalse((boolean)rootLoggerConfig.isIncludeLocation());
        LoggerConfig loggerConfig = (LoggerConfig)loggers.get("org.apache.logging.log4j");
        Assertions.assertEquals((Object)Level.DEBUG, (Object)loggerConfig.getLevel());
        Assertions.assertTrue((boolean)loggerConfig.isIncludeLocation());
        Filter filter = config.getFilter();
        Assertions.assertNotNull((Object)filter, (String)"No Filter");
        MatcherAssert.assertThat((Object)filter, (Matcher)Matchers.instanceOf(ThresholdFilter.class));
        List customLevels = config.getCustomLevels();
        Assertions.assertNotNull((Object)filter, (String)"No CustomLevels");
        Assertions.assertEquals((int)1, (int)customLevels.size());
        CustomLevelConfig customLevel = (CustomLevelConfig)customLevels.get(0);
        Assertions.assertEquals((Object)"Panic", (Object)customLevel.getLevelName());
        Assertions.assertEquals((int)17, (int)customLevel.getIntLevel());
        Logger logger = LogManager.getLogger(this.getClass());
        logger.info("Welcome to Log4j!");
    }
}

