/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.config.builder.api.AppenderComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilderFactory;
import org.apache.logging.log4j.core.config.builder.api.FilterComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.LayoutComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.LoggerComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.RootLoggerComponentBuilder;
import org.apache.logging.log4j.core.filter.CompositeFilter;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.hamcrest.MapMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="functional")
public class TestConfigurator {
    private static final String CONFIG_NAME = "ConfigTest";
    private static final String FILESEP = System.getProperty("file.separator");
    private LoggerContext ctx = null;
    private static final String[] CHARS = new String[]{"aaaaaaaaaa", "bbbbbbbbbb", "cccccccccc", "dddddddddd", "eeeeeeeeee", "ffffffffff", "gggggggggg", "hhhhhhhhhh", "iiiiiiiiii", "jjjjjjjjjj", "kkkkkkkkkk", "llllllllll", "mmmmmmmmmm"};

    @AfterEach
    public void cleanup() {
        System.clearProperty("log4j.configurationFile");
        if (this.ctx != null) {
            Configurator.shutdown((LoggerContext)this.ctx);
            this.ctx = null;
        }
    }

    @Test
    public void testInitialize_Name_PathName() throws Exception {
        this.ctx = Configurator.initialize((String)"Test1", (String)"target/test-classes/log4j2-config.xml");
        LogManager.getLogger((String)"org.apache.test.TestConfigurator");
        Configuration config = this.ctx.getConfiguration();
        Assertions.assertNotNull((Object)config, (String)"No configuration");
        Assertions.assertEquals((Object)CONFIG_NAME, (Object)config.getName(), (String)"Incorrect Configuration.");
        Map map = config.getAppenders();
        Assertions.assertNotNull((Object)map, (String)"Appenders map should not be null.");
        MatcherAssert.assertThat((Object)map, MapMatchers.hasSize((Matcher<Integer>)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
        MatcherAssert.assertThat((String)"Wrong configuration", (Object)map, (Matcher)Matchers.hasKey((Object)"List"));
        Configurator.shutdown((LoggerContext)this.ctx);
        config = this.ctx.getConfiguration();
        Assertions.assertEquals((Object)"Null", (Object)config.getName(), (String)"Unexpected Configuration.");
    }

    @Test
    public void testInitialize_Name_ClassLoader_URI() throws Exception {
        this.ctx = Configurator.initialize((String)"Test1", null, (URI)new File("target/test-classes/log4j2-config.xml").toURI());
        LogManager.getLogger((String)"org.apache.test.TestConfigurator");
        Configuration config = this.ctx.getConfiguration();
        Assertions.assertNotNull((Object)config, (String)"No configuration");
        Assertions.assertEquals((Object)CONFIG_NAME, (Object)config.getName(), (String)"Incorrect Configuration.");
        Map map = config.getAppenders();
        Assertions.assertNotNull((Object)map, (String)"Appenders map should not be null.");
        MatcherAssert.assertThat((Object)map, MapMatchers.hasSize((Matcher<Integer>)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
        MatcherAssert.assertThat((String)"Wrong configuration", (Object)map, (Matcher)Matchers.hasKey((Object)"List"));
        Configurator.shutdown((LoggerContext)this.ctx);
        config = this.ctx.getConfiguration();
        Assertions.assertEquals((Object)"Null", (Object)config.getName(), (String)"Unexpected Configuration.");
    }

    @Test
    public void testInitialize_InputStream_File() throws Exception {
        File file = new File("target/test-classes/log4j2-config.xml");
        FileInputStream is = new FileInputStream(file);
        ConfigurationSource source = new ConfigurationSource((InputStream)is, file);
        this.ctx = Configurator.initialize(null, (ConfigurationSource)source);
        LogManager.getLogger((String)"org.apache.test.TestConfigurator");
        Configuration config = this.ctx.getConfiguration();
        Assertions.assertNotNull((Object)config, (String)"No configuration");
        Assertions.assertEquals((Object)CONFIG_NAME, (Object)config.getName(), (String)"Incorrect Configuration.");
        Map map = config.getAppenders();
        Assertions.assertNotNull((Object)map, (String)"Appenders map should not be null.");
        MatcherAssert.assertThat((Object)map, MapMatchers.hasSize((Matcher<Integer>)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
        MatcherAssert.assertThat((String)"Wrong configuration", (Object)map, (Matcher)Matchers.hasKey((Object)"List"));
        Configurator.shutdown((LoggerContext)this.ctx);
        config = this.ctx.getConfiguration();
        Assertions.assertEquals((Object)"Null", (Object)config.getName(), (String)"Unexpected Configuration.");
    }

    @Test
    public void testInitialize_NullClassLoader_ConfigurationSourceWithInputStream_NoId() throws Exception {
        FileInputStream is = new FileInputStream("target/test-classes/log4j2-config.xml");
        ConfigurationSource source = new ConfigurationSource((InputStream)is);
        this.ctx = Configurator.initialize(null, (ConfigurationSource)source);
        LogManager.getLogger((String)"org.apache.test.TestConfigurator");
        Configuration config = this.ctx.getConfiguration();
        Assertions.assertNotNull((Object)config, (String)"No configuration");
        Assertions.assertEquals((Object)CONFIG_NAME, (Object)config.getName(), (String)"Incorrect Configuration.");
        Map map = config.getAppenders();
        Assertions.assertNotNull((Object)map, (String)"Appenders map should not be null.");
        MatcherAssert.assertThat((Object)map, MapMatchers.hasSize((Matcher<Integer>)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
        MatcherAssert.assertThat((String)"Wrong configuration", (Object)map, (Matcher)Matchers.hasKey((Object)"List"));
        Configurator.shutdown((LoggerContext)this.ctx);
        config = this.ctx.getConfiguration();
        Assertions.assertEquals((Object)"Null", (Object)config.getName(), (String)"Unexpected Configuration.");
    }

    @Test
    public void testInitialize_Name_LocationName() throws Exception {
        this.ctx = Configurator.initialize((String)"Test1", (String)"log4j2-config.xml");
        LogManager.getLogger((String)"org.apache.test.TestConfigurator");
        Configuration config = this.ctx.getConfiguration();
        Assertions.assertNotNull((Object)config, (String)"No configuration");
        Assertions.assertEquals((Object)CONFIG_NAME, (Object)config.getName(), (String)"Incorrect Configuration.");
        Map map = config.getAppenders();
        Assertions.assertNotNull((Object)map, (String)"Appenders map should not be null.");
        MatcherAssert.assertThat((Object)map, MapMatchers.hasSize((Matcher<Integer>)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
        MatcherAssert.assertThat((String)"Wrong configuration", (Object)map, (Matcher)Matchers.hasKey((Object)"List"));
        Configurator.shutdown((LoggerContext)this.ctx);
        config = this.ctx.getConfiguration();
        Assertions.assertEquals((Object)"Null", (Object)config.getName(), (String)"Unexpected Configuration.");
    }

    @Test
    public void testFromClassPathProperty() throws Exception {
        System.setProperty("log4j.configurationFile", "classpath:log4j2-config.xml");
        this.ctx = Configurator.initialize((String)"Test1", null);
        LogManager.getLogger((String)"org.apache.test.TestConfigurator");
        Configuration config = this.ctx.getConfiguration();
        Assertions.assertNotNull((Object)config, (String)"No configuration");
        Assertions.assertEquals((Object)CONFIG_NAME, (Object)config.getName(), (String)"Incorrect Configuration.");
        Map map = config.getAppenders();
        Assertions.assertNotNull((Object)map, (String)"Appenders map should not be null.");
        MatcherAssert.assertThat((Object)map, MapMatchers.hasSize((Matcher<Integer>)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
        MatcherAssert.assertThat((String)"Wrong configuration", (Object)map, (Matcher)Matchers.hasKey((Object)"List"));
        Configurator.shutdown((LoggerContext)this.ctx);
        config = this.ctx.getConfiguration();
        Assertions.assertEquals((Object)"Null", (Object)config.getName(), (String)"Unexpected Configuration.");
    }

    @Test
    public void testFromClassPathWithClassPathPrefix() throws Exception {
        this.ctx = Configurator.initialize((String)"Test1", (String)"classpath:log4j2-config.xml");
        LogManager.getLogger((String)"org.apache.test.TestConfigurator");
        Configuration config = this.ctx.getConfiguration();
        Assertions.assertNotNull((Object)config, (String)"No configuration");
        Assertions.assertEquals((Object)CONFIG_NAME, (Object)config.getName(), (String)"Incorrect Configuration.");
        Map map = config.getAppenders();
        Assertions.assertNotNull((Object)map, (String)"Appenders map should not be null.");
        MatcherAssert.assertThat((Object)map, MapMatchers.hasSize((Matcher<Integer>)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
        MatcherAssert.assertThat((String)"Wrong configuration", (Object)map, (Matcher)Matchers.hasKey((Object)"List"));
        Configurator.shutdown((LoggerContext)this.ctx);
        config = this.ctx.getConfiguration();
        Assertions.assertEquals((Object)"Null", (Object)config.getName(), (String)"Incorrect Configuration.");
    }

    @Test
    public void testFromClassPathWithClassLoaderPrefix() throws Exception {
        this.ctx = Configurator.initialize((String)"Test1", (String)"classloader:log4j2-config.xml");
        LogManager.getLogger((String)"org.apache.test.TestConfigurator");
        Configuration config = this.ctx.getConfiguration();
        Assertions.assertNotNull((Object)config, (String)"No configuration");
        Assertions.assertEquals((Object)CONFIG_NAME, (Object)config.getName(), (String)"Incorrect Configuration.");
        Map map = config.getAppenders();
        Assertions.assertNotNull((Object)map, (String)"Appenders map should not be null.");
        MatcherAssert.assertThat((Object)map, MapMatchers.hasSize((Matcher<Integer>)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
        MatcherAssert.assertThat((String)"Wrong configuration", (Object)map, (Matcher)Matchers.hasKey((Object)"List"));
        Configurator.shutdown((LoggerContext)this.ctx);
        config = this.ctx.getConfiguration();
        Assertions.assertEquals((Object)"Null", (Object)config.getName(), (String)"Incorrect Configuration.");
    }

    @Test
    public void testByName() throws Exception {
        this.ctx = Configurator.initialize((String)"-config", null);
        LogManager.getLogger((String)"org.apache.test.TestConfigurator");
        Configuration config = this.ctx.getConfiguration();
        Assertions.assertNotNull((Object)config, (String)"No configuration");
        Assertions.assertEquals((Object)CONFIG_NAME, (Object)config.getName(), (String)"Incorrect Configuration.");
        Map map = config.getAppenders();
        Assertions.assertNotNull((Object)map, (String)"Appenders map should not be null.");
        MatcherAssert.assertThat((Object)map, MapMatchers.hasSize((Matcher<Integer>)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
        MatcherAssert.assertThat((String)"Wrong configuration", (Object)map, (Matcher)Matchers.hasKey((Object)"List"));
        Configurator.shutdown((LoggerContext)this.ctx);
        config = this.ctx.getConfiguration();
        Assertions.assertEquals((Object)"Null", (Object)config.getName(), (String)"Unexpected Configuration.");
    }

    @Test
    public void testReconfiguration() throws Exception {
        File file = new File("target/test-classes/log4j2-config.xml");
        Assertions.assertTrue((boolean)file.setLastModified(System.currentTimeMillis() - 120000L), (String)"setLastModified should have succeeded.");
        this.ctx = Configurator.initialize((String)"Test1", (String)"target/test-classes/log4j2-config.xml");
        Logger logger = LogManager.getLogger((String)"org.apache.test.TestConfigurator");
        Configuration config = this.ctx.getConfiguration();
        Assertions.assertNotNull((Object)config, (String)"No configuration");
        Assertions.assertEquals((Object)CONFIG_NAME, (Object)config.getName(), (String)"Incorrect Configuration.");
        Map map = config.getAppenders();
        Assertions.assertNotNull((Object)map, (String)"Appenders map should not be null.");
        MatcherAssert.assertThat((Object)map, MapMatchers.hasSize((Matcher<Integer>)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
        MatcherAssert.assertThat((String)"Wrong configuration", (Object)map, (Matcher)Matchers.hasKey((Object)"List"));
        Thread.sleep(50L);
        if (!file.setLastModified(System.currentTimeMillis())) {
            Thread.sleep(500L);
        }
        Assertions.assertTrue((boolean)file.setLastModified(System.currentTimeMillis()), (String)"setLastModified should have succeeded.");
        TimeUnit.SECONDS.sleep(config.getWatchManager().getIntervalSeconds() + 1);
        for (int i = 0; i < 100; ++i) {
            logger.debug("Test message " + i);
        }
        Thread.sleep(100L);
        if (Matchers.is((Matcher)Matchers.theInstance((Object)config)).matches((Object)this.ctx.getConfiguration())) {
            Thread.sleep(2000L);
        }
        Configuration newConfig = this.ctx.getConfiguration();
        MatcherAssert.assertThat((String)"Configuration not reset", (Object)newConfig, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.theInstance((Object)config))));
        Configurator.shutdown((LoggerContext)this.ctx);
        config = this.ctx.getConfiguration();
        Assertions.assertEquals((Object)"Null", (Object)config.getName(), (String)"Unexpected Configuration.");
    }

    @Test
    public void testEnvironment() throws Exception {
        this.ctx = Configurator.initialize((String)"-config", null);
        LogManager.getLogger((String)"org.apache.test.TestConfigurator");
        Configuration config = this.ctx.getConfiguration();
        Assertions.assertNotNull((Object)config, (String)"No configuration");
        Assertions.assertEquals((Object)CONFIG_NAME, (Object)config.getName(), (String)"Incorrect Configuration.");
        Map map = config.getAppenders();
        Assertions.assertNotNull((Object)map, (String)"Appenders map should not be null.");
        MatcherAssert.assertThat((Object)map, MapMatchers.hasSize((Matcher<Integer>)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
        MatcherAssert.assertThat((String)"No ListAppender named List2", (Object)map, (Matcher)Matchers.hasKey((Object)"List2"));
        Appender app = (Appender)map.get("List2");
        Layout layout = app.getLayout();
        Assertions.assertNotNull((Object)layout, (String)"Appender List2 does not have a Layout");
        MatcherAssert.assertThat((String)"Appender List2 is not configured with a PatternLayout", (Object)layout, (Matcher)Matchers.instanceOf(PatternLayout.class));
        String pattern = ((PatternLayout)layout).getConversionPattern();
        Assertions.assertNotNull((Object)pattern, (String)"No conversion pattern for List2 PatternLayout");
        Assertions.assertFalse((boolean)pattern.startsWith("${env:PATH}"), (String)"Environment variable was not substituted");
    }

    @Test
    public void testNoLoggers() throws Exception {
        this.ctx = Configurator.initialize((String)"Test1", (String)"bad/log4j-loggers.xml");
        LogManager.getLogger((String)"org.apache.test.TestConfigurator");
        Configuration config = this.ctx.getConfiguration();
        Assertions.assertNotNull((Object)config, (String)"No configuration");
        String name = "Default@" + Integer.toHexString(config.hashCode());
        Assertions.assertEquals((Object)name, (Object)config.getName(), (String)"Unexpected Configuration.");
    }

    @Test
    public void testBadStatus() throws Exception {
        this.ctx = Configurator.initialize((String)"Test1", (String)"bad/log4j-status.xml");
        LogManager.getLogger((String)"org.apache.test.TestConfigurator");
        Configuration config = this.ctx.getConfiguration();
        Assertions.assertNotNull((Object)config, (String)"No configuration");
        Assertions.assertEquals((Object)"XMLConfigTest", (Object)config.getName(), (String)"Unexpected Configuration");
        LoggerConfig root = config.getLoggerConfig("");
        Assertions.assertNotNull((Object)root, (String)"No Root Logger");
        Assertions.assertSame((Object)Level.ERROR, (Object)root.getLevel(), (String)("Expected error level, was " + root.getLevel()));
    }

    @Test
    public void testBadFilterParam() throws Exception {
        this.ctx = Configurator.initialize((String)"Test1", (String)"bad/log4j-badfilterparam.xml");
        LogManager.getLogger((String)"org.apache.test.TestConfigurator");
        Configuration config = this.ctx.getConfiguration();
        Assertions.assertNotNull((Object)config, (String)"No configuration");
        Assertions.assertEquals((Object)"XMLConfigTest", (Object)config.getName(), (String)"Unexpected Configuration");
        LoggerConfig lcfg = config.getLoggerConfig("org.apache.logging.log4j.test1");
        Assertions.assertNotNull((Object)lcfg, (String)"No Logger");
        Filter filter = lcfg.getFilter();
        Assertions.assertNull((Object)filter, (String)"Unexpected Filter");
    }

    @Test
    public void testNoFilters() throws Exception {
        this.ctx = Configurator.initialize((String)"Test1", (String)"bad/log4j-nofilter.xml");
        LogManager.getLogger((String)"org.apache.test.TestConfigurator");
        Configuration config = this.ctx.getConfiguration();
        Assertions.assertNotNull((Object)config, (String)"No configuration");
        Assertions.assertEquals((Object)"XMLConfigTest", (Object)config.getName(), (String)"Unexpected Configuration");
        LoggerConfig lcfg = config.getLoggerConfig("org.apache.logging.log4j.test1");
        Assertions.assertNotNull((Object)lcfg, (String)"No Logger");
        Filter filter = lcfg.getFilter();
        Assertions.assertNotNull((Object)filter, (String)"No Filter");
        MatcherAssert.assertThat((Object)filter, (Matcher)Matchers.instanceOf(CompositeFilter.class));
        Assertions.assertTrue((boolean)((CompositeFilter)filter).isEmpty(), (String)"Unexpected filters");
    }

    @Test
    public void testBadLayout() throws Exception {
        this.ctx = Configurator.initialize((String)"Test1", (String)"bad/log4j-badlayout.xml");
        LogManager.getLogger((String)"org.apache.test.TestConfigurator");
        Configuration config = this.ctx.getConfiguration();
        Assertions.assertNotNull((Object)config, (String)"No configuration");
        Assertions.assertEquals((Object)"XMLConfigTest", (Object)config.getName(), (String)"Unexpected Configuration");
    }

    @Test
    public void testBadFileName() throws Exception {
        StringBuilder dir = new StringBuilder("/VeryLongDirectoryName");
        for (String element : CHARS) {
            dir.append(element);
            dir.append(element.toUpperCase());
        }
        String value = FILESEP.equals("/") ? dir.toString() + "/test.log" : "1:/target/bad:file.log";
        System.setProperty("testfile", value);
        this.ctx = Configurator.initialize((String)"Test1", (String)"bad/log4j-badfilename.xml");
        LogManager.getLogger((String)"org.apache.test.TestConfigurator");
        Configuration config = this.ctx.getConfiguration();
        Assertions.assertNotNull((Object)config, (String)"No configuration");
        Assertions.assertEquals((Object)"XMLConfigTest", (Object)config.getName(), (String)"Unexpected Configuration");
        MatcherAssert.assertThat((Object)config.getAppenders(), MapMatchers.hasSize((Matcher<Integer>)Matchers.equalTo((Object)2)));
    }

    @Test
    public void testBuilder() throws Exception {
        ConfigurationBuilder builder = ConfigurationBuilderFactory.newConfigurationBuilder();
        builder.setStatusLevel(Level.ERROR);
        builder.setConfigurationName("BuilderTest");
        builder.add((FilterComponentBuilder)builder.newFilter("ThresholdFilter", Filter.Result.ACCEPT, Filter.Result.NEUTRAL).addAttribute("level", Level.DEBUG));
        AppenderComponentBuilder appenderBuilder = (AppenderComponentBuilder)builder.newAppender("Stdout", "CONSOLE").addAttribute("target", (Enum)ConsoleAppender.Target.SYSTEM_OUT);
        appenderBuilder.add((LayoutComponentBuilder)builder.newLayout("PatternLayout").addAttribute("pattern", "%d [%t] %-5level: %msg%n%throwable"));
        appenderBuilder.add((FilterComponentBuilder)builder.newFilter("MarkerFilter", Filter.Result.DENY, Filter.Result.NEUTRAL).addAttribute("marker", "FLOW"));
        builder.add(appenderBuilder);
        builder.add((LoggerComponentBuilder)((LoggerComponentBuilder)builder.newLogger("org.apache.logging.log4j", Level.DEBUG).add(builder.newAppenderRef("Stdout"))).addAttribute("additivity", false));
        builder.add((RootLoggerComponentBuilder)builder.newRootLogger(Level.ERROR).add(builder.newAppenderRef("Stdout")));
        this.ctx = Configurator.initialize((Configuration)((Configuration)builder.build()));
        Configuration config = this.ctx.getConfiguration();
        Assertions.assertNotNull((Object)config, (String)"No configuration");
        Assertions.assertEquals((Object)"BuilderTest", (Object)config.getName(), (String)"Unexpected Configuration");
        MatcherAssert.assertThat((Object)config.getAppenders(), MapMatchers.hasSize((Matcher<Integer>)Matchers.equalTo((Object)1)));
    }

    @Test
    public void testRolling() throws Exception {
        ConfigurationBuilder builder = ConfigurationBuilderFactory.newConfigurationBuilder();
        builder.setStatusLevel(Level.ERROR);
        builder.setConfigurationName("RollingBuilder");
        AppenderComponentBuilder appenderBuilder = (AppenderComponentBuilder)builder.newAppender("Stdout", "CONSOLE").addAttribute("target", (Enum)ConsoleAppender.Target.SYSTEM_OUT);
        appenderBuilder.add((LayoutComponentBuilder)builder.newLayout("PatternLayout").addAttribute("pattern", "%d [%t] %-5level: %msg%n%throwable"));
        builder.add(appenderBuilder);
        LayoutComponentBuilder layoutBuilder = (LayoutComponentBuilder)builder.newLayout("PatternLayout").addAttribute("pattern", "%d [%t] %-5level: %msg%n");
        ComponentBuilder triggeringPolicy = builder.newComponent("Policies").addComponent(builder.newComponent("CronTriggeringPolicy").addAttribute("schedule", "0 0 0 * * ?")).addComponent(builder.newComponent("SizeBasedTriggeringPolicy").addAttribute("size", "100M"));
        appenderBuilder = (AppenderComponentBuilder)((AppenderComponentBuilder)((AppenderComponentBuilder)builder.newAppender("rolling", "RollingFile").addAttribute("fileName", "target/rolling.log")).addAttribute("filePattern", "target/archive/rolling-%d{MM-dd-yy}.log.gz")).add(layoutBuilder).addComponent(triggeringPolicy);
        builder.add(appenderBuilder);
        builder.add((LoggerComponentBuilder)((LoggerComponentBuilder)builder.newLogger("TestLogger", Level.DEBUG).add(builder.newAppenderRef("rolling"))).addAttribute("additivity", false));
        builder.add((RootLoggerComponentBuilder)builder.newRootLogger(Level.DEBUG).add(builder.newAppenderRef("rolling")));
        Configuration config = (Configuration)builder.build();
        config.initialize();
        Assertions.assertNotNull((Object)config.getAppender("rolling"), (String)"No rolling file appender");
        Assertions.assertEquals((Object)"RollingBuilder", (Object)config.getName(), (String)"Unexpected Configuration");
        LoggerContext ctx = Configurator.initialize((Configuration)config);
        Configurator.shutdown((LoggerContext)ctx);
    }

    @Test
    public void testBuilderWithScripts() throws Exception {
        String script = "if (logEvent.getLoggerName().equals(\"NoLocation\")) {\n                return \"NoLocation\";\n            } else if (logEvent.getMarker() != null && logEvent.getMarker().isInstanceOf(\"FLOW\")) {\n                return \"Flow\";\n            } else {\n                return null;\n            }";
        ConfigurationBuilder builder = ConfigurationBuilderFactory.newConfigurationBuilder();
        builder.setStatusLevel(Level.ERROR);
        builder.setConfigurationName("BuilderTest");
        builder.add(builder.newScriptFile("filter.groovy", "target/test-classes/scripts/filter.groovy").addIsWatched(true));
        AppenderComponentBuilder appenderBuilder = (AppenderComponentBuilder)builder.newAppender("Stdout", "CONSOLE").addAttribute("target", (Enum)ConsoleAppender.Target.SYSTEM_OUT);
        appenderBuilder.add((LayoutComponentBuilder)builder.newLayout("PatternLayout").addComponent(builder.newComponent("ScriptPatternSelector").addAttribute("defaultPattern", "[%-5level] %c{1.} %C{1.}.%M.%L %msg%n").addComponent(builder.newComponent("PatternMatch").addAttribute("key", "NoLocation").addAttribute("pattern", "[%-5level] %c{1.} %msg%n")).addComponent(builder.newComponent("PatternMatch").addAttribute("key", "FLOW").addAttribute("pattern", "[%-5level] %c{1.} ====== %C{1.}.%M:%L %msg ======%n")).addComponent(builder.newComponent("selectorScript", "Script", "if (logEvent.getLoggerName().equals(\"NoLocation\")) {\n                return \"NoLocation\";\n            } else if (logEvent.getMarker() != null && logEvent.getMarker().isInstanceOf(\"FLOW\")) {\n                return \"Flow\";\n            } else {\n                return null;\n            }").addAttribute("language", "beanshell"))));
        appenderBuilder.add((FilterComponentBuilder)builder.newFilter("ScriptFilter", Filter.Result.DENY, Filter.Result.NEUTRAL).addComponent(builder.newComponent("ScriptRef").addAttribute("ref", "filter.groovy")));
        builder.add(appenderBuilder);
        builder.add((LoggerComponentBuilder)((LoggerComponentBuilder)builder.newLogger("org.apache.logging.log4j", Level.DEBUG).add(builder.newAppenderRef("Stdout"))).addAttribute("additivity", false));
        builder.add((RootLoggerComponentBuilder)builder.newRootLogger(Level.ERROR).add(builder.newAppenderRef("Stdout")));
        this.ctx = Configurator.initialize((Configuration)((Configuration)builder.build()));
        Configuration config = this.ctx.getConfiguration();
        Assertions.assertNotNull((Object)config, (String)"No configuration");
        Assertions.assertEquals((Object)"BuilderTest", (Object)config.getName(), (String)"Unexpected Configuration");
        MatcherAssert.assertThat((Object)config.getAppenders(), MapMatchers.hasSize((Matcher<Integer>)Matchers.equalTo((Object)1)));
        Assertions.assertNotNull((Object)config.getScriptManager().getScript("filter.groovy"), (String)"Filter script not found");
        Assertions.assertNotNull((Object)config.getScriptManager().getScript("selectorScript"), (String)"pattern selector script not found");
    }
}

