/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.xml.XmlConfiguration;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class NestedLoggerConfigTest {
    private final String prefix;

    @Parameterized.Parameters(name="{0}")
    public static List<String> data() throws IOException {
        return ImmutableList.of((Object)"logger-config/LoggerConfig/", (Object)"logger-config/AsyncLoggerConfig/");
    }

    public NestedLoggerConfigTest(String prefix) {
        this.prefix = prefix;
    }

    @Test
    public void testInheritParentDefaultLevel() throws IOException {
        Configuration configuration = this.loadConfiguration(this.prefix + "default-level.xml");
        try {
            Assert.assertEquals((Object)Level.ERROR, (Object)configuration.getLoggerConfig("com.foo").getLevel());
        }
        finally {
            configuration.stop();
        }
    }

    @Test
    public void testInheritParentLevel() throws IOException {
        Configuration configuration = this.loadConfiguration(this.prefix + "inherit-level.xml");
        try {
            Assert.assertEquals((Object)Level.TRACE, (Object)configuration.getLoggerConfig("com.foo").getLevel());
        }
        finally {
            configuration.stop();
        }
    }

    private Configuration loadConfiguration(String resourcePath) throws IOException {
        try (InputStream in = this.getClass().getClassLoader().getResourceAsStream(resourcePath);){
            XmlConfiguration configuration = new XmlConfiguration(new LoggerContext("test"), new ConfigurationSource(in));
            configuration.initialize();
            configuration.start();
            XmlConfiguration xmlConfiguration = configuration;
            return xmlConfiguration;
        }
    }
}

