/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config;

import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.appender.rolling.CompositeTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.SizeBasedTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.TimeBasedTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.junit.LoggerContextSource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

class MultipleTriggeringPolicyTest {
    MultipleTriggeringPolicyTest() {
    }

    @Test
    @LoggerContextSource(value="LOG4J2-1100/log4j2.xml")
    void xml(Configuration configuration) {
        this.assertBothTriggeringPoliciesConfigured(configuration);
    }

    @Test
    @Tag(value="json")
    @LoggerContextSource(value="LOG4J2-1100/log4j2.json")
    void json(Configuration configuration) {
        this.assertBothTriggeringPoliciesConfigured(configuration);
    }

    @Test
    @Tag(value="yaml")
    @LoggerContextSource(value="LOG4J2-1100/log4j2-good.yaml")
    void yaml(Configuration configuration) {
        this.assertBothTriggeringPoliciesConfigured(configuration);
    }

    @Test
    @Tag(value="yaml")
    @Disabled(value="LOG4J2-1100 demonstration")
    @LoggerContextSource(value="LOG4J2-1100/log4j2-good.yaml")
    void unsupportedYamlSyntax(Configuration configuration) {
        this.assertBothTriggeringPoliciesConfigured(configuration);
    }

    void assertBothTriggeringPoliciesConfigured(Configuration configuration) {
        TimeBasedTriggeringPolicy timeBasedTriggeringPolicy;
        SizeBasedTriggeringPolicy sizeBasedTriggeringPolicy;
        RollingFileAppender appender = (RollingFileAppender)configuration.getAppender("File");
        Assertions.assertNotNull((Object)appender);
        CompositeTriggeringPolicy compositeTriggeringPolicy = (CompositeTriggeringPolicy)appender.getTriggeringPolicy();
        Assertions.assertNotNull((Object)compositeTriggeringPolicy);
        TriggeringPolicy[] triggeringPolicies = compositeTriggeringPolicy.getTriggeringPolicies();
        Assertions.assertEquals((int)2, (int)triggeringPolicies.length);
        if (triggeringPolicies[0] instanceof SizeBasedTriggeringPolicy) {
            sizeBasedTriggeringPolicy = (SizeBasedTriggeringPolicy)triggeringPolicies[0];
            timeBasedTriggeringPolicy = (TimeBasedTriggeringPolicy)triggeringPolicies[1];
        } else {
            sizeBasedTriggeringPolicy = (SizeBasedTriggeringPolicy)triggeringPolicies[1];
            timeBasedTriggeringPolicy = (TimeBasedTriggeringPolicy)triggeringPolicies[0];
        }
        Assertions.assertEquals((int)7, (int)timeBasedTriggeringPolicy.getInterval());
        Assertions.assertEquals((long)0x6400000L, (long)sizeBasedTriggeringPolicy.getMaxFileSize());
    }
}

