/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LifeCycle;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.config.ReliabilityStrategy;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.util.Supplier;
import org.junit.jupiter.api.Assertions;
import org.opentest4j.MultipleFailuresError;

public class MockReliabilityStrategy
implements ReliabilityStrategy {
    private final LoggerConfig config;
    private final List<AssertionError> errors = Collections.synchronizedList(new ArrayList());

    public MockReliabilityStrategy(LoggerConfig config) {
        this.config = config;
    }

    public void log(Supplier<LoggerConfig> reconfigured, String loggerName, String fqcn, Marker marker, Level level, Message data, Throwable t) {
        this.config.log(loggerName, fqcn, marker, level, data, t);
    }

    public void log(Supplier<LoggerConfig> reconfigured, LogEvent event) {
        this.config.log(event);
    }

    public LoggerConfig getActiveLoggerConfig(Supplier<LoggerConfig> next) {
        return this.config;
    }

    public void afterLogEvent() {
    }

    public void beforeStopAppenders() {
        this.checkState(LifeCycle.State.STOPPED, (LifeCycle)this.config);
        for (Appender appender : this.config.getAppenders().values()) {
            this.checkState(LifeCycle.State.STARTED, (LifeCycle)appender);
        }
    }

    public void beforeStopConfiguration(Configuration configuration) {
        this.checkState(LifeCycle.State.STOPPING, (LifeCycle)configuration);
        this.checkState(LifeCycle.State.STARTED, (LifeCycle)this.config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rethrowAssertionErrors() {
        List<AssertionError> list = this.errors;
        synchronized (list) {
            if (!this.errors.isEmpty()) {
                throw new MultipleFailuresError(null, this.errors);
            }
        }
    }

    private void checkState(LifeCycle.State expected, LifeCycle object) {
        try {
            Assertions.assertSame((Object)expected, (Object)object.getState(), () -> "Expected state " + expected + " for LifeCycle object " + object);
        }
        catch (AssertionError e) {
            this.errors.add(e);
        }
    }
}

