/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.junit.LoggerContextSource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="yaml")
@LoggerContextSource(value="log4j2-2134.yml")
public class JiraLog4j2_2134Test {
    @Test
    public void testRefresh() {
        PatternLayout layout;
        Logger log = LogManager.getLogger(this.getClass());
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        PatternLayout layout1 = layout = PatternLayout.newBuilder().withPattern("%d [%t] %p %c - %m%n").withConfiguration(config).build();
        FileAppender appender = ((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)FileAppender.newBuilder().withFileName("target/test.log").setLayout((Layout)layout1)).setConfiguration(config)).withBufferSize(4000)).setName("File")).build();
        config.addAppender((Appender)appender);
        AppenderRef ref = AppenderRef.createAppenderRef((String)"File", null, null);
        AppenderRef[] refs = new AppenderRef[]{ref};
        LoggerConfig loggerConfig = LoggerConfig.createLogger((boolean)false, (Level)Level.INFO, (String)"testlog4j2refresh", (String)"true", (AppenderRef[])refs, null, (Configuration)config, null);
        loggerConfig.addAppender((Appender)appender, null, null);
        config.addLogger("testlog4j2refresh", loggerConfig);
        ctx.stop();
        ctx.start(config);
        Assertions.assertDoesNotThrow(() -> log.error("Info message"));
    }

    @Test
    public void testRefreshMinimalCodeStart() {
        Logger log = LogManager.getLogger(this.getClass());
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        ctx.start(config);
        Assertions.assertDoesNotThrow(() -> log.error("Info message"));
    }

    @Test
    public void testRefreshMinimalCodeStopStart() {
        Logger log = LogManager.getLogger(this.getClass());
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        ctx.stop();
        ctx.start();
        Assertions.assertDoesNotThrow(() -> log.error("Info message"));
    }

    @Test
    public void testRefreshMinimalCodeStopStartConfig() {
        Logger log = LogManager.getLogger(this.getClass());
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        ctx.stop();
        ctx.start(config);
        Assertions.assertDoesNotThrow(() -> log.error("Info message"));
    }

    @Test
    public void testRefreshDeprecatedApis() {
        Logger log = LogManager.getLogger(this.getClass());
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        PatternLayout layout = PatternLayout.createLayout((String)"%d [%t] %p %c - %m%n", null, (Configuration)config, null, null, (boolean)false, (boolean)false, null, null);
        FileAppender appender = FileAppender.createAppender((String)"target/test.log", (String)"false", (String)"false", (String)"File", (String)"true", (String)"false", (String)"false", (String)"4000", (Layout)layout, null, (String)"false", null, (Configuration)config);
        appender.start();
        config.addAppender((Appender)appender);
        AppenderRef ref = AppenderRef.createAppenderRef((String)"File", null, null);
        AppenderRef[] refs = new AppenderRef[]{ref};
        LoggerConfig loggerConfig = LoggerConfig.createLogger((String)"false", (Level)Level.INFO, (String)"testlog4j2refresh", (String)"true", (AppenderRef[])refs, null, (Configuration)config, null);
        loggerConfig.addAppender((Appender)appender, null, null);
        config.addLogger("testlog4j2refresh", loggerConfig);
        ctx.stop();
        ctx.start(config);
        Assertions.assertDoesNotThrow(() -> log.error("Info message"));
    }
}

