/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.async;

import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.categories.AsyncLoggers;
import org.apache.logging.log4j.core.async.AsyncLoggerContextSelector;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={AsyncLoggers.class})
public class AsyncLoggersWithAsyncAppenderTest {
    @ClassRule
    public static LoggerContextRule context = new LoggerContextRule("AsyncLoggersWithAsyncAppenderTest.xml", AsyncLoggerContextSelector.class);

    @Test
    public void testLoggingWorks() throws Exception {
        Logger logger = LogManager.getLogger();
        logger.error("This {} a test", (Object)"is");
        logger.warn("Hello {}!", (Object)"world");
        Thread.sleep(100L);
        List<String> list = context.getListAppender("List").getMessages();
        Assert.assertNotNull((String)"No events generated", list);
        Assert.assertEquals((String)"Incorrect number of events ", (long)2L, (long)list.size());
        String msg = list.get(0);
        String expected = this.getClass().getName() + " This {} a test - [is] - This is a test";
        Assert.assertEquals((Object)expected, (Object)msg);
        msg = list.get(1);
        expected = this.getClass().getName() + " Hello {}! - [world] - Hello world!";
        Assert.assertEquals((Object)expected, (Object)msg);
    }
}

