/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.async;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.categories.AsyncLoggers;
import org.apache.logging.log4j.core.GarbageCollectionHelper;
import org.apache.logging.log4j.core.async.AsyncLogger;
import org.apache.logging.log4j.core.async.AsyncLoggerContextSelector;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.util.StringBuilderFormattable;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={AsyncLoggers.class})
public class AsyncLoggerTestArgumentFreedOnError {
    @BeforeClass
    public static void beforeClass() {
        System.setProperty("log4j2.enable.threadlocals", "true");
        System.setProperty("log4j2.enable.direct.encoders", "true");
        System.setProperty("log4j2.is.webapp", "false");
        System.setProperty("log4j.format.msg.async", "true");
        System.setProperty("Log4jContextSelector", AsyncLoggerContextSelector.class.getName());
    }

    @AfterClass
    public static void afterClass() {
        System.setProperty("Log4jContextSelector", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMessageIsGarbageCollected() throws Exception {
        AsyncLogger log = (AsyncLogger)LogManager.getLogger((String)"com.foo.Bar");
        CountDownLatch garbageCollectionLatch = new CountDownLatch(1);
        log.fatal((Message)new ThrowingMessage(garbageCollectionLatch));
        gcHelper.run();
        try (GarbageCollectionHelper gcHelper = new GarbageCollectionHelper();){
            Assert.assertTrue((String)"Parameter should have been garbage collected", (boolean)garbageCollectionLatch.await(30L, TimeUnit.SECONDS));
        }
    }

    private static class ThrowingMessage
    implements Message,
    StringBuilderFormattable {
        private final CountDownLatch latch;

        ThrowingMessage(CountDownLatch latch) {
            this.latch = latch;
        }

        protected void finalize() throws Throwable {
            this.latch.countDown();
            super.finalize();
        }

        public String getFormattedMessage() {
            throw new Error("Expected");
        }

        public String getFormat() {
            return "";
        }

        public Object[] getParameters() {
            return new Object[0];
        }

        public Throwable getThrowable() {
            return null;
        }

        public void formatTo(StringBuilder buffer) {
            throw new Error("Expected");
        }
    }
}

