/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.async;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.ThreadContextTestAccess;
import org.apache.logging.log4j.core.CoreLoggerContexts;
import org.apache.logging.log4j.core.async.AsyncLoggerConfig;
import org.apache.logging.log4j.core.async.AsyncLoggerContext;
import org.apache.logging.log4j.core.async.AsyncLoggerContextSelector;
import org.apache.logging.log4j.core.jmx.RingBufferAdmin;
import org.apache.logging.log4j.spi.DefaultThreadContextMap;
import org.apache.logging.log4j.spi.LoggerContext;
import org.apache.logging.log4j.spi.ReadOnlyThreadContextMap;
import org.apache.logging.log4j.util.PropertiesUtil;
import org.apache.logging.log4j.util.Unbox;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public abstract class AbstractAsyncThreadContextTestBase {
    private static final int LINE_COUNT = 130;
    private final ContextImpl contextImpl;
    private final Mode asyncMode;

    @BeforeClass
    public static void beforeClass() {
        System.setProperty("log4j2.is.webapp", "false");
        System.setProperty("AsyncLogger.RingBufferSize", "128");
        System.setProperty("AsyncLoggerConfig.RingBufferSize", "128");
    }

    @AfterClass
    public static void afterClass() {
        System.clearProperty("AsyncLogger.RingBufferSize");
        System.clearProperty("AsyncLoggerConfig.RingBufferSize");
        System.clearProperty("Log4jContextSelector");
        System.clearProperty("log4j.configurationFile");
        System.clearProperty("log4j2.garbagefree.threadContextMap");
        System.clearProperty("log4j2.is.webapp");
        System.clearProperty("log4j2.threadContextMap");
    }

    public AbstractAsyncThreadContextTestBase(ContextImpl contextImpl, Mode asyncMode) {
        this.contextImpl = contextImpl;
        this.asyncMode = asyncMode;
        asyncMode.initSelector();
        asyncMode.initConfigFile();
        contextImpl.init();
    }

    @Test
    public void testAsyncLogWritesToLog() throws Exception {
        int i;
        File[] files;
        for (File f : files = new File[]{new File("target", "AsyncLoggerTest.log"), new File("target", "SynchronousContextTest.log"), new File("target", "AsyncLoggerAndAsyncAppenderTest.log"), new File("target", "AsyncAppenderContextTest.log")}) {
            f.delete();
        }
        ThreadContext.push((String)"stackvalue");
        ThreadContext.put((String)"KEY", (String)"mapvalue");
        Logger log = LogManager.getLogger((String)"com.foo.Bar");
        LoggerContext loggerContext = LogManager.getContext((boolean)false);
        String loggerContextName = loggerContext.getClass().getSimpleName();
        RingBufferAdmin ring = loggerContext instanceof AsyncLoggerContext ? ((AsyncLoggerContext)loggerContext).createRingBufferAdmin() : ((AsyncLoggerConfig)((org.apache.logging.log4j.core.Logger)log).get()).createRingBufferAdmin("");
        for (i = 0; i < 130; ++i) {
            while (i >= 128 && ring.getRemainingCapacity() == 0L) {
                Thread.sleep(1L);
            }
            if ((i & 1) == 1) {
                ThreadContext.put((String)"count", (String)String.valueOf(i));
            } else {
                ThreadContext.remove((String)"count");
            }
            log.info("{} {} {} i={}", (Object)this.contextImpl, (Object)AbstractAsyncThreadContextTestBase.contextMap(), (Object)loggerContextName, (Object)Unbox.box((int)i));
        }
        ThreadContext.pop();
        CoreLoggerContexts.stopLoggerContext(false, files[0]);
        this.checkResult(files[0], loggerContextName);
        if (this.asyncMode == Mode.MIXED || this.asyncMode == Mode.BOTH_ALL_ASYNC_AND_MIXED) {
            for (i = 1; i < files.length; ++i) {
                this.checkResult(files[i], loggerContextName);
            }
        }
        LogManager.shutdown();
    }

    private static String contextMap() {
        ReadOnlyThreadContextMap impl = ThreadContext.getThreadContextMap();
        return impl == null ? ContextImpl.WEBAPP.implClassSimpleName() : impl.getClass().getSimpleName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkResult(File file, String loggerContextName) throws IOException {
        String contextDesc = (Object)((Object)this.contextImpl) + " " + this.contextImpl.implClassSimpleName() + " " + loggerContextName;
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            for (int i = 0; i < 130; ++i) {
                String line = reader.readLine();
                String expect = (i & 1) == 1 ? "INFO c.f.Bar mapvalue [stackvalue] {KEY=mapvalue, configProp=configValue, configProp2=configValue2, count=" + i + "} " + contextDesc + " i=" + i : "INFO c.f.Bar mapvalue [stackvalue] {KEY=mapvalue, configProp=configValue, configProp2=configValue2} " + contextDesc + " i=" + i;
                Assert.assertEquals((String)(file.getName() + ": line " + i), (Object)expect, (Object)line);
            }
            String noMoreLines = reader.readLine();
            Assert.assertNull((String)"done", (Object)noMoreLines);
        }
        finally {
            file.delete();
        }
    }

    static enum ContextImpl {
        WEBAPP,
        GARBAGE_FREE,
        COPY_ON_WRITE;


        void init() {
            System.clearProperty("log4j2.threadContextMap");
            String PACKAGE = "org.apache.logging.log4j.spi.";
            System.setProperty("log4j2.threadContextMap", "org.apache.logging.log4j.spi." + this.implClassSimpleName());
            PropertiesUtil.getProperties().reload();
            ThreadContextTestAccess.init();
        }

        public String implClassSimpleName() {
            switch (this) {
                case WEBAPP: {
                    return DefaultThreadContextMap.class.getSimpleName();
                }
                case GARBAGE_FREE: {
                    return "GarbageFreeSortedArrayThreadContextMap";
                }
                case COPY_ON_WRITE: {
                    return "CopyOnWriteSortedArrayThreadContextMap";
                }
            }
            throw new IllegalStateException("Unknown state " + (Object)((Object)this));
        }
    }

    static enum Mode {
        ALL_ASYNC,
        MIXED,
        BOTH_ALL_ASYNC_AND_MIXED;


        void initSelector() {
            if (this == ALL_ASYNC || this == BOTH_ALL_ASYNC_AND_MIXED) {
                System.setProperty("Log4jContextSelector", AsyncLoggerContextSelector.class.getName());
            } else {
                System.clearProperty("Log4jContextSelector");
            }
        }

        void initConfigFile() {
            String file = this == ALL_ASYNC ? "AsyncLoggerThreadContextTest.xml" : "AsyncLoggerConfigThreadContextTest.xml";
            System.setProperty("log4j.configurationFile", file);
        }
    }
}

