/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling;

import java.io.File;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Calendar;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.appender.rolling.CronTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.RollingFileManager;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.util.CronExpression;
import org.apache.logging.log4j.hamcrest.Descriptors;
import org.apache.logging.log4j.hamcrest.FileMatchers;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.apache.logging.log4j.status.StatusLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;

public class RollingAppenderCronOnceADayTest {
    private static final int CRON_DELAY = 10;
    private static final String UTF_8 = "UTF-8";
    private static final String CONFIG = "log4j-rolling-cron-once-a-day.xml";
    private static final String CONFIG_TARGET = "log4j-rolling-cron-once-a-day-target.xml";
    private static final String TARGET = "target";
    private static final String DIR = "target/rolling-cron-once-a-day";
    private static final String FILE = "target/rolling-cron-once-a-day/rollingtest.log";
    private static final String TARGET_TEST_CLASSES = "target/test-classes";
    private static String cronExpression;
    private static long remainingTime;
    private final LoggerContextRule loggerContextRule = new LoggerContextRule("log4j-rolling-cron-once-a-day-target.xml");
    @Rule
    public RuleChain chain = this.loggerContextRule.withCleanFoldersRule("target/rolling-cron-once-a-day");

    @BeforeClass
    public static void beforeClass() throws Exception {
        Path src = FileSystems.getDefault().getPath(TARGET_TEST_CLASSES, CONFIG);
        String content = new String(Files.readAllBytes(src), UTF_8);
        Calendar cal = Calendar.getInstance();
        cal.add(13, 10);
        remainingTime = cal.getTimeInMillis() - System.currentTimeMillis();
        cronExpression = String.format("%d %d %d * * ?", cal.get(13), cal.get(12), cal.get(11));
        content = content.replace("@CRON_EXPR@", cronExpression);
        Files.write(FileSystems.getDefault().getPath(TARGET_TEST_CLASSES, CONFIG_TARGET), content.getBytes(UTF_8), new OpenOption[0]);
        StatusLogger.getLogger().debug("Cron expression will be " + cronExpression + " in " + remainingTime + "ms");
    }

    @Test
    public void testAppender() throws Exception {
        File[] files;
        Logger logger = this.loggerContextRule.getLogger();
        File file = new File(FILE);
        Assert.assertTrue((String)"Log file does not exist", (boolean)file.exists());
        logger.debug("This is test message number 1, waiting for rolling");
        RollingFileAppender app = (RollingFileAppender)this.loggerContextRule.getLoggerContext().getConfiguration().getAppender("RollingFile");
        TriggeringPolicy policy = ((RollingFileManager)app.getManager()).getTriggeringPolicy();
        Assert.assertNotNull((String)"No triggering policy", (Object)policy);
        Assert.assertTrue((String)"Incorrect policy type", (boolean)(policy instanceof CronTriggeringPolicy));
        CronExpression expression = ((CronTriggeringPolicy)policy).getCronExpression();
        Assert.assertEquals((String)"Incorrect cron expresion", (Object)cronExpression, (Object)expression.getCronExpression());
        logger.debug("Cron expression will be {}", (Object)expression.getCronExpression());
        for (int i = 1; i <= 20; ++i) {
            logger.debug("Adding first event {}", (Object)i);
        }
        Thread.sleep(remainingTime);
        File dir = new File(DIR);
        Assert.assertTrue((String)"Directory not created", (dir.exists() && dir.listFiles().length > 0 ? 1 : 0) != 0);
        for (int i = 1; i < 5; ++i) {
            logger.debug("Adding some more event {}", (Object)i);
            Thread.sleep(1000L);
        }
        Matcher<File> hasGzippedFile = FileMatchers.hasName(Descriptors.that(Matchers.endsWith((String)".gz")));
        int count = 0;
        for (File generatedFile : files = dir.listFiles()) {
            if (!hasGzippedFile.matches((Object)generatedFile)) continue;
            ++count;
        }
        Assert.assertNotEquals((String)"No compressed files found", (long)0L, (long)count);
        Assert.assertEquals((String)"Multiple files found", (long)1L, (long)count);
    }
}

