/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling;

import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.appender.RollingRandomAccessFileAppender;
import org.apache.logging.log4j.core.appender.rolling.CronTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.DefaultRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.RollingFileManager;
import org.apache.logging.log4j.core.appender.rolling.RolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.NullConfiguration;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class CronTriggeringPolicyTest {
    private static final String CRON_EXPRESSION = "0 0 0 * * ?";
    private NullConfiguration configuration;

    @BeforeEach
    public void before() {
        this.configuration = new NullConfiguration();
    }

    private CronTriggeringPolicy createPolicy() {
        return CronTriggeringPolicy.createPolicy((Configuration)this.configuration, (String)Boolean.TRUE.toString(), (String)CRON_EXPRESSION);
    }

    private DefaultRolloverStrategy createStrategy() {
        return DefaultRolloverStrategy.createStrategy((String)"7", (String)"1", (String)"max", null, null, (boolean)false, (Configuration)this.configuration);
    }

    private void testBuilder() {
        RollingFileAppender raf = ((RollingFileAppender.Builder)((RollingFileAppender.Builder)RollingFileAppender.newBuilder().setName("test1")).withFileName("target/testcmd1.log").withFilePattern("target/testcmd1.log.%d{yyyy-MM-dd}").withPolicy((TriggeringPolicy)this.createPolicy()).withStrategy((RolloverStrategy)this.createStrategy()).setConfiguration((Configuration)this.configuration)).build();
        Assertions.assertNotNull((Object)raf);
    }

    @Test
    public void testBuilderOnce() {
        this.testBuilder();
    }

    @Test
    public void testLoggerContextAndBuilder() {
        Configurator.initialize((Configuration)this.configuration);
        this.testBuilder();
    }

    @Test
    public void testRollingRandomAccessFileAppender() {
        ((RollingRandomAccessFileAppender.Builder)((RollingRandomAccessFileAppender.Builder)RollingRandomAccessFileAppender.newBuilder().setName("test2")).withFileName("target/testcmd2.log").withFilePattern("target/testcmd2.log.%d{yyyy-MM-dd}").withPolicy((TriggeringPolicy)this.createPolicy()).withStrategy((RolloverStrategy)this.createStrategy()).setConfiguration((Configuration)this.configuration)).build();
    }

    @Test
    public void testBuilderSequence() {
        this.testBuilder();
        this.testBuilder();
    }

    private void testFactoryMethod() {
        CronTriggeringPolicy triggerPolicy = this.createPolicy();
        DefaultRolloverStrategy rolloverStrategy = this.createStrategy();
        try (RollingFileManager fileManager = RollingFileManager.getFileManager((String)"target/testcmd3.log", (String)"target/testcmd3.log.%d{yyyy-MM-dd}", (boolean)true, (boolean)true, (TriggeringPolicy)triggerPolicy, (RolloverStrategy)rolloverStrategy, null, (Layout)PatternLayout.createDefaultLayout(), (int)0, (boolean)true, (boolean)false, null, null, null, (Configuration)this.configuration);){
            fileManager.initialize();
            fileManager.rollover();
        }
    }

    @Test
    public void testFactoryMethodOnce() {
        this.testFactoryMethod();
    }

    @Test
    public void testFactoryMethodSequence() {
        this.testFactoryMethod();
        this.testFactoryMethod();
    }
}

