/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rewrite;

import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.EventLogger;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.hamcrest.MapMatchers;
import org.apache.logging.log4j.junit.LoggerContextSource;
import org.apache.logging.log4j.junit.Named;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.StructuredDataMessage;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@LoggerContextSource(value="log4j-rewrite.xml")
public class RewriteAppenderTest {
    private final ListAppender app;
    private final ListAppender app2;

    public RewriteAppenderTest(@Named(value="List") ListAppender app, @Named(value="List2") ListAppender app2) {
        this.app = app.clear();
        this.app2 = app2.clear();
    }

    @Test
    public void rewriteTest() {
        StructuredDataMessage msg = new StructuredDataMessage("Test", "This is a test", "Service");
        msg.put("Key1", "Value1");
        msg.put("Key2", "Value2");
        EventLogger.logEvent((StructuredDataMessage)msg);
        List<LogEvent> list = this.app.getEvents();
        MatcherAssert.assertThat(list, (Matcher)Matchers.hasSize((int)1));
        LogEvent event = list.get(0);
        Message m = event.getMessage();
        MatcherAssert.assertThat((Object)m, (Matcher)Matchers.instanceOf(StructuredDataMessage.class));
        StructuredDataMessage message = (StructuredDataMessage)m;
        Map map = message.getData();
        Assertions.assertNotNull((Object)map, (String)"No Map");
        MatcherAssert.assertThat((Object)map, MapMatchers.hasSize(3));
        String value = (String)map.get("Key1");
        Assertions.assertEquals((Object)"Apache", (Object)value);
    }

    @Test
    public void testProperties(LoggerContext context) {
        ExtendedLogger logger = context.getLogger(RewriteAppenderTest.class);
        logger.debug("Test properties rewrite");
        List<String> list = this.app2.getMessages();
        MatcherAssert.assertThat(list, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)list.get(0), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"{user.dir}")));
        Assertions.assertNotNull(list, (String)"No events generated");
        Assertions.assertEquals((int)list.size(), (int)1, (String)("Incorrect number of events. Expected 1, got " + list.size()));
        Assertions.assertFalse((boolean)list.get(0).contains("{user."), (String)"Did not resolve user name");
    }

    @Test
    public void testFilter(LoggerContext context) {
        StructuredDataMessage msg = new StructuredDataMessage("Test", "This is a test", "Service");
        msg.put("Key1", "Value2");
        msg.put("Key2", "Value1");
        Logger logger = context.getLogger("org.apache.logging.log4j.core.Logging");
        logger.debug((Message)msg);
        msg = new StructuredDataMessage("Test", "This is a test", "Service");
        msg.put("Key1", "Value1");
        msg.put("Key2", "Value2");
        logger.trace((Message)msg);
        MatcherAssert.assertThat(this.app.getEvents(), (Matcher)Matchers.empty());
    }
}

