/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.StringLayout;
import org.apache.logging.log4j.core.appender.ConfigurationTestUtils;
import org.apache.logging.log4j.core.appender.WriterAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class WriterAppenderTest {
    private static final String TEST_MSG = "FOO ERROR";
    private String testMethodName;

    @BeforeEach
    void setUp(TestInfo testInfo) {
        this.testMethodName = testInfo.getTestMethod().map(Method::getName).orElseGet(() -> ((TestInfo)testInfo).getDisplayName());
    }

    private String getName(Writer writer) {
        return writer.getClass().getSimpleName() + "." + this.testMethodName;
    }

    private void test(ByteArrayOutputStream out, Writer writer) {
        String name = this.getName(writer);
        this.addAppender(writer, name);
        Logger logger = LogManager.getLogger((String)name);
        logger.error(TEST_MSG);
        String actual = out.toString();
        MatcherAssert.assertThat((Object)actual, (Matcher)Matchers.containsString((String)TEST_MSG));
    }

    private void test(Writer writer) {
        String name = this.getName(writer);
        this.addAppender(writer, name);
        Logger logger = LogManager.getLogger((String)name);
        logger.error(TEST_MSG);
        String actual = writer.toString();
        MatcherAssert.assertThat((Object)actual, (Matcher)Matchers.containsString((String)TEST_MSG));
    }

    private void addAppender(Writer writer, String writerName) {
        LoggerContext context = LoggerContext.getContext((boolean)false);
        Configuration config = context.getConfiguration();
        PatternLayout layout = PatternLayout.createDefaultLayout((Configuration)config);
        WriterAppender appender = WriterAppender.createAppender((StringLayout)layout, null, (Writer)writer, (String)writerName, (boolean)false, (boolean)true);
        appender.start();
        config.addAppender((Appender)appender);
        ConfigurationTestUtils.updateLoggers((Appender)appender, config);
    }

    @Test
    public void testWriterAppenderToCharArrayWriter() {
        this.test(new CharArrayWriter());
    }

    @Test
    public void testWriterAppenderToOutputStreamWriter() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter(out);
        this.test(out, writer);
    }

    @Test
    public void testWriterAppenderToPrintWriter() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintWriter writer = new PrintWriter(out);
        this.test(out, writer);
    }

    @Test
    public void testWriterAppenderToStringWriter() {
        this.test(new StringWriter());
    }

    @Test
    public void testBuilder() {
        ((WriterAppender.Builder)WriterAppender.newBuilder().setTarget((Writer)new StringWriter()).setName("testWriterAppender")).build();
    }
}

