/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.util.Iterator;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import org.apache.logging.dumbster.smtp.SimpleSmtpServer;
import org.apache.logging.dumbster.smtp.SmtpMessage;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.categories.Appenders;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.SmtpAppender;
import org.apache.logging.log4j.core.net.MimeMessageBuilder;
import org.apache.logging.log4j.test.AvailablePortFinder;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={Appenders.Smtp.class})
public class SmtpAppenderTest {
    private static final String HOST = "localhost";

    @Test
    public void testMessageFactorySetFrom() throws MessagingException {
        MimeMessageBuilder builder = new MimeMessageBuilder(null);
        String address = "testing@example.com";
        Assert.assertNull((Object)builder.build().getFrom());
        builder.setFrom(null);
        Address[] array = null;
        InternetAddress addr = InternetAddress.getLocalAddress(null);
        if (addr != null) {
            array = new Address[]{addr};
        }
        Assert.assertArrayEquals(array, (Object[])builder.build().getFrom());
        builder.setFrom("testing@example.com");
        Assert.assertArrayEquals((Object[])new Address[]{new InternetAddress("testing@example.com")}, (Object[])builder.build().getFrom());
    }

    @Test
    public void testMessageFactorySetReplyTo() throws MessagingException {
        MimeMessageBuilder builder = new MimeMessageBuilder(null);
        String addresses = "testing1@example.com,testing2@example.com";
        Assert.assertNull((Object)builder.build().getReplyTo());
        builder.setReplyTo(null);
        Assert.assertNull((Object)builder.build().getReplyTo());
        builder.setReplyTo("testing1@example.com,testing2@example.com");
        Assert.assertArrayEquals((Object[])InternetAddress.parse((String)"testing1@example.com,testing2@example.com"), (Object[])builder.build().getReplyTo());
    }

    @Test
    public void testMessageFactorySetRecipients() throws MessagingException {
        MimeMessageBuilder builder = new MimeMessageBuilder(null);
        String addresses = "testing1@example.com,testing2@example.com";
        Assert.assertNull((Object)builder.build().getRecipients(Message.RecipientType.TO));
        builder.setRecipients(Message.RecipientType.TO, null);
        Assert.assertNull((Object)builder.build().getRecipients(Message.RecipientType.TO));
        builder.setRecipients(Message.RecipientType.TO, "testing1@example.com,testing2@example.com");
        Assert.assertArrayEquals((Object[])InternetAddress.parse((String)"testing1@example.com,testing2@example.com"), (Object[])builder.build().getRecipients(Message.RecipientType.TO));
    }

    @Test
    public void testMessageFactorySetSubject() throws MessagingException {
        MimeMessageBuilder builder = new MimeMessageBuilder(null);
        String subject = "Test Subject";
        Assert.assertNull((Object)builder.build().getSubject());
        builder.setSubject(null);
        Assert.assertNull((Object)builder.build().getSubject());
        builder.setSubject("Test Subject");
        Assert.assertEquals((Object)"Test Subject", (Object)builder.build().getSubject());
    }

    @Test
    public void testDelivery() {
        String subjectKey = this.getClass().getName();
        String subjectValue = "SubjectValue1";
        ThreadContext.put((String)subjectKey, (String)"SubjectValue1");
        int smtpPort = AvailablePortFinder.getNextAvailable();
        SmtpAppender appender = ((SmtpAppender.Builder)SmtpAppender.newBuilder().setName("Test")).setTo("to@example.com").setCc("cc@example.com").setBcc("bcc@example.com").setFrom("from@example.com").setReplyTo("replyTo@example.com").setSubject("Subject Pattern %X{" + subjectKey + "}").setSmtpHost(HOST).setSmtpPort(smtpPort).setBufferSize(3).build();
        appender.start();
        LoggerContext context = LoggerContext.getContext();
        Logger root = context.getLogger("SMTPAppenderTest");
        root.addAppender((Appender)appender);
        root.setAdditive(false);
        root.setLevel(Level.DEBUG);
        SimpleSmtpServer server = SimpleSmtpServer.start(smtpPort);
        root.debug("Debug message #1");
        root.debug("Debug message #2");
        root.debug("Debug message #3");
        root.debug("Debug message #4");
        root.error("Error with exception", (Throwable)new RuntimeException("Exception message"));
        root.error("Error message #2");
        server.stop();
        Assert.assertTrue((server.getReceivedEmailSize() == 2 ? 1 : 0) != 0);
        Iterator<SmtpMessage> messages = server.getReceivedEmail();
        SmtpMessage email = messages.next();
        Assert.assertEquals((Object)"to@example.com", (Object)email.getHeaderValue("To"));
        Assert.assertEquals((Object)"cc@example.com", (Object)email.getHeaderValue("Cc"));
        Assert.assertEquals((Object)"from@example.com", (Object)email.getHeaderValue("From"));
        Assert.assertEquals((Object)"replyTo@example.com", (Object)email.getHeaderValue("Reply-To"));
        String headerValue = email.getHeaderValue("Subject");
        Assert.assertEquals((Object)headerValue, (Object)"Subject Pattern SubjectValue1");
        String body = email.getBody();
        Assert.assertFalse((boolean)body.contains("Debug message #1"));
        Assert.assertTrue((boolean)body.contains("Debug message #2"));
        Assert.assertTrue((boolean)body.contains("Debug message #3"));
        Assert.assertTrue((boolean)body.contains("Debug message #4"));
        Assert.assertTrue((boolean)body.contains("Error with exception"));
        Assert.assertTrue((boolean)body.contains("RuntimeException"));
        Assert.assertTrue((boolean)body.contains("Exception message"));
        Assert.assertFalse((boolean)body.contains("Error message #2"));
        SmtpMessage email2 = messages.next();
        String body2 = email2.getBody();
        Assert.assertFalse((boolean)body2.contains("Debug message #4"));
        Assert.assertFalse((boolean)body2.contains("Error with exception"));
        Assert.assertTrue((boolean)body2.contains("Error message #2"));
    }
}

