/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.junit.LoggerContextSource;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ScriptAppenderSelectorTest {
    @Test
    @LoggerContextSource(value="log4j-appender-selector-javascript.xml")
    void testJavaScriptSelector(Configuration config) {
        ScriptAppenderSelectorTest.verify(config);
    }

    @Test
    @LoggerContextSource(value="log4j-appender-selector-groovy.xml")
    void testGroovySelector(Configuration config) {
        ScriptAppenderSelectorTest.verify(config);
    }

    static void verify(Configuration config) {
        Assertions.assertNull((Object)config.getAppender("List1"), (String)"List1 appender should not be initialized");
        Assertions.assertNull((Object)config.getAppender("List2"), (String)"List2 appender should not be initialized");
        ListAppender listAppender = (ListAppender)config.getAppender("SelectIt");
        Assertions.assertNotNull((Object)((Object)listAppender));
        ExtendedLogger logger = config.getLoggerContext().getLogger(ScriptAppenderSelectorTest.class);
        logger.error("Hello");
        MatcherAssert.assertThat(listAppender.getEvents(), (Matcher)Matchers.hasSize((int)1));
        logger.error("World");
        MatcherAssert.assertThat(listAppender.getEvents(), (Matcher)Matchers.hasSize((int)2));
        logger.error(MarkerManager.getMarker((String)"HEXDUMP"), "DEADBEEF");
        MatcherAssert.assertThat(listAppender.getEvents(), (Matcher)Matchers.hasSize((int)3));
    }
}

