/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.util.Integers;
import org.apache.logging.log4j.junit.CleanUpFiles;
import org.apache.logging.log4j.junit.LoggerContextSource;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@CleanUpFiles(value={"target/MemoryMappedFileAppenderTest.log", "target/MemoryMappedFileAppenderRemapTest.log", "target/MemoryMappedFileAppenderLocationTest.log"})
public class MemoryMappedFileAppenderTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @LoggerContextSource(value="MemoryMappedFileAppenderTest.xml")
    public void testMemMapBasics(LoggerContext context) throws Exception {
        ExtendedLogger log = context.getLogger(this.getClass());
        Path logFile = Paths.get("target", "MemoryMappedFileAppenderTest.log");
        try {
            log.warn("Test log1");
            Assertions.assertTrue((boolean)Files.exists(logFile, new LinkOption[0]));
            Assertions.assertEquals((long)0x2000000L, (long)Files.size(logFile));
            log.warn("Test log2");
            Assertions.assertEquals((long)0x2000000L, (long)Files.size(logFile));
        }
        finally {
            context.stop();
        }
        int LINESEP = System.lineSeparator().length();
        Assertions.assertEquals((long)(18 + 2 * LINESEP), (long)Files.size(logFile));
        List<String> lines = Files.readAllLines(logFile);
        MatcherAssert.assertThat(lines, (Matcher)Matchers.both((Matcher)Matchers.hasSize((int)2)).and(Matchers.contains((Object[])new Object[]{"Test log1", "Test log2"})));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @LoggerContextSource(value="MemoryMappedFileAppenderRemapTest.xml")
    public void testMemMapExtendsIfNeeded(LoggerContext context) throws Exception {
        ExtendedLogger log = context.getLogger(this.getClass());
        Path logFile = Paths.get("target", "MemoryMappedFileAppenderRemapTest.log");
        char[] text = new char[256];
        Arrays.fill(text, 'A');
        String str = new String(text);
        try {
            log.warn("Test log1");
            Assertions.assertTrue((boolean)Files.exists(logFile, new LinkOption[0]));
            Assertions.assertEquals((long)256L, (long)Files.size(logFile));
            log.warn(str);
            Assertions.assertEquals((long)512L, (long)Files.size(logFile));
            log.warn(str);
            Assertions.assertEquals((long)768L, (long)Files.size(logFile));
        }
        finally {
            context.stop();
        }
        Assertions.assertEquals((long)(521 + 3 * System.lineSeparator().length()), (long)Files.size(logFile), (String)"Expected file size to shrink");
        List<String> lines = Files.readAllLines(logFile);
        MatcherAssert.assertThat(lines, (Matcher)Matchers.both((Matcher)Matchers.hasSize((int)3)).and(Matchers.contains((Object[])new Object[]{"Test log1", str, str})));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @LoggerContextSource(value="MemoryMappedFileAppenderLocationTest.xml")
    void testMemMapLocation(LoggerContext context) throws Exception {
        ExtendedLogger log = context.getLogger(this.getClass());
        Path logFile = Paths.get("target", "MemoryMappedFileAppenderLocationTest.log");
        int expectedFileLength = Integers.ceilingNextPowerOfTwo((int)32000);
        Assertions.assertEquals((int)32768, (int)expectedFileLength);
        try {
            log.warn("Test log1");
            Assertions.assertTrue((boolean)Files.exists(logFile, new LinkOption[0]));
            Assertions.assertEquals((long)expectedFileLength, (long)Files.size(logFile));
            log.warn("Test log2");
            Assertions.assertEquals((long)expectedFileLength, (long)Files.size(logFile));
        }
        finally {
            context.stop();
        }
        Assertions.assertEquals((long)(272 + 2 * System.lineSeparator().length()), (long)Files.size(logFile), (String)"Expected file size to shrink");
        List<String> lines = Files.readAllLines(logFile);
        MatcherAssert.assertThat(lines, (Matcher)Matchers.both((Matcher)Matchers.hasSize((int)2)).and(Matchers.contains((Object[])new Object[]{"org.apache.logging.log4j.core.appender.MemoryMappedFileAppenderTest.testMemMapLocation(MemoryMappedFileAppenderTest.java:104): Test log1", "org.apache.logging.log4j.core.appender.MemoryMappedFileAppenderTest.testMemMapLocation(MemoryMappedFileAppenderTest.java:107): Test log2"})));
    }
}

