/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.List;
import org.apache.logging.log4j.categories.Layouts;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.impl.Log4jLogEventTest;
import org.apache.logging.log4j.core.selector.ContextSelector;
import org.apache.logging.log4j.core.selector.CoreContextSelectors;
import org.apache.logging.log4j.junit.CleanFiles;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={Layouts.Json.class})
public class JsonCompleteFileAppenderTest {
    private final File logFile = new File("target", "JsonCompleteFileAppenderTest.log");
    private final LoggerContextRule loggerContextRule;
    private final CleanFiles cleanFiles;
    @Rule
    public RuleChain ruleChain;

    public JsonCompleteFileAppenderTest(Class<ContextSelector> contextSelector) {
        this.loggerContextRule = new LoggerContextRule("JsonCompleteFileAppenderTest.xml", contextSelector);
        this.cleanFiles = new CleanFiles(this.logFile);
        this.ruleChain = RuleChain.outerRule((TestRule)this.cleanFiles).around((TestRule)this.loggerContextRule);
    }

    @BeforeClass
    public static void beforeClass() {
        System.setProperty("log4j.Clock", Log4jLogEventTest.FixedTimeClock.class.getName());
    }

    @AfterClass
    public static void afterClass() {
        System.clearProperty("log4j.Clock");
    }

    @Parameterized.Parameters(name="{0}")
    public static Class<?>[] getParameters() {
        return CoreContextSelectors.CLASSES;
    }

    @Test
    public void testFlushAtEndOfBatch() throws Exception {
        Logger logger = this.loggerContextRule.getLogger("com.foo.Bar");
        String logMsg = "Message flushed with immediate flush=true";
        logger.info("Message flushed with immediate flush=true");
        logger.error("Message flushed with immediate flush=true", (Throwable)new IllegalArgumentException("badarg"));
        this.loggerContextRule.getLoggerContext().stop();
        List<String> lines = Files.readAllLines(this.logFile.toPath(), Charset.forName("UTF8"));
        String[] expected = new String[]{"[", "{", "  \"instant\" : {", "    \"epochSecond\" : 1234567,", "    \"nanoOfSecond\" : 890000000", "  },", "  \"thread\" : \"main\",", "  \"level\" : \"INFO\",", "  \"loggerName\" : \"com.foo.Bar\",", "  \"message\" : \"Message flushed with immediate flush=true\",", "  \"endOfBatch\" : false,", "  \"loggerFqcn\" : \"org.apache.logging.log4j.spi.AbstractLogger\","};
        for (int i = 0; i < expected.length; ++i) {
            String line = lines.get(i);
            Assert.assertTrue((String)("line " + i + " incorrect: [" + line + "], does not contain: [" + expected[i] + ']'), (boolean)line.contains(expected[i]));
        }
        String location = "testFlushAtEndOfBatch";
        Assert.assertTrue((String)"no location", (!lines.get(0).contains("testFlushAtEndOfBatch") ? 1 : 0) != 0);
    }
}

