/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core;

import java.io.File;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.junit.LoggerContextSource;
import org.apache.logging.log4j.junit.Named;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

@LoggerContextSource(value="log4j-test2.properties")
public class PropertiesFileConfigTest {
    private static final String CONFIG = "target/test-classes/log4j-test2.properties";
    private final Logger logger;

    public PropertiesFileConfigTest(LoggerContext context) {
        this.logger = context.getLogger("LoggerTest");
    }

    @BeforeEach
    void clear(@Named(value="List") ListAppender appender) {
        appender.clear();
    }

    @Test
    public void testReconfiguration(LoggerContext context) throws Exception {
        Configuration newConfig;
        Configuration oldConfig = context.getConfiguration();
        int MONITOR_INTERVAL_SECONDS = 5;
        File file = new File(CONFIG);
        long orig = file.lastModified();
        long newTime = orig + 10000L;
        Assertions.assertTrue((boolean)file.setLastModified(newTime), (String)"setLastModified should have succeeded.");
        TimeUnit.SECONDS.sleep(6L);
        for (int i = 0; i < 17; ++i) {
            this.logger.info("Reconfigure");
        }
        int loopCount = 0;
        do {
            Thread.sleep(100L);
        } while ((newConfig = context.getConfiguration()) == oldConfig && loopCount++ < 5);
        Assertions.assertNotSame((Object)newConfig, (Object)oldConfig, (String)"Reconfiguration failed");
    }
}

