/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core;

import java.io.File;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.junit.LoggerContextSource;
import org.apache.logging.log4j.junit.Named;
import org.apache.logging.log4j.junit.ReconfigurationPolicy;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.MessageFactory;
import org.apache.logging.log4j.message.ParameterizedMessageFactory;
import org.apache.logging.log4j.message.SimpleMessage;
import org.apache.logging.log4j.message.StringFormatterMessageFactory;
import org.apache.logging.log4j.message.StructuredDataMessage;
import org.apache.logging.log4j.spi.AbstractLogger;
import org.apache.logging.log4j.spi.MessageFactory2Adapter;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

@LoggerContextSource(value="log4j-test2.xml", reconfigure=ReconfigurationPolicy.AFTER_EACH)
public class LoggerTest {
    static final String CONFIG = "log4j-test2.xml";
    Logger logger;
    Logger loggerChild;
    Logger loggerGrandchild;
    private final ListAppender app;
    private final ListAppender host;
    private final ListAppender noThrown;

    public LoggerTest(LoggerContext context, @Named(value="List") ListAppender app, @Named(value="HostTest") ListAppender host, @Named(value="NoThrowable") ListAppender noThrown) {
        this.logger = context.getLogger("LoggerTest");
        this.loggerChild = context.getLogger("LoggerTest.child");
        this.loggerGrandchild = context.getLogger("LoggerTest.child.grand");
        this.app = app.clear();
        this.host = host.clear();
        this.noThrown = noThrown.clear();
    }

    private void assertEventCount(List<LogEvent> events, int expected) {
        Assertions.assertEquals((int)expected, (int)events.size(), (String)"Incorrect number of events.");
    }

    @Test
    public void builder() {
        this.logger.atDebug().withLocation().log("Hello");
        Marker marker = MarkerManager.getMarker((String)"test");
        this.logger.atError().withMarker(marker).log("Hello {}", (Object)"John");
        this.logger.atWarn().withThrowable(new Throwable("This is a test")).log((Message)new SimpleMessage("Log4j rocks!"));
        List<LogEvent> events = this.app.getEvents();
        this.assertEventCount(events, 3);
        Assertions.assertEquals((Object)"org.apache.logging.log4j.core.LoggerTest.builder(LoggerTest.java:81)", (Object)events.get(0).getSource().toString(), (String)"Incorrect location");
        Assertions.assertEquals((Object)Level.DEBUG, (Object)events.get(0).getLevel(), (String)"Incorrect Level");
        MatcherAssert.assertThat((String)"Incorrect message", (Object)events.get(1).getMessage().getFormattedMessage(), (Matcher)CoreMatchers.equalTo((Object)"Hello John"));
        Assertions.assertNotNull((Object)events.get(2).getThrown(), (String)"Missing Throwable");
    }

    @Test
    public void basicFlow() {
        this.logger.traceEntry();
        this.logger.traceExit();
        List<LogEvent> events = this.app.getEvents();
        this.assertEventCount(events, 2);
    }

    @Test
    public void simpleFlow() {
        this.logger.entry(new Object[]{CONFIG});
        this.logger.traceExit((Object)0);
        List<LogEvent> events = this.app.getEvents();
        this.assertEventCount(events, 2);
    }

    @Test
    public void simpleFlowDepreacted() {
        this.logger.entry(new Object[]{CONFIG});
        this.logger.exit((Object)0);
        List<LogEvent> events = this.app.getEvents();
        this.assertEventCount(events, 2);
    }

    @Test
    public void throwing() {
        this.logger.throwing((Throwable)new IllegalArgumentException("Test Exception"));
        List<LogEvent> events = this.app.getEvents();
        this.assertEventCount(events, 1);
    }

    @Test
    public void catching() {
        try {
            throw new NullPointerException();
        }
        catch (Exception e) {
            this.logger.catching((Throwable)e);
            List<LogEvent> events = this.app.getEvents();
            this.assertEventCount(events, 1);
            return;
        }
    }

    @Test
    public void debug() {
        this.logger.debug("Debug message");
        List<LogEvent> events = this.app.getEvents();
        this.assertEventCount(events, 1);
    }

    @Test
    public void debugChangeLevel() {
        this.logger.debug("Debug message 1");
        this.assertEventCount(this.app.getEvents(), 1);
        Configurator.setLevel((String)this.logger.getName(), (Level)Level.OFF);
        this.logger.debug("Debug message 2");
        this.assertEventCount(this.app.getEvents(), 1);
        Configurator.setLevel((String)this.logger.getName(), (Level)Level.DEBUG);
        this.logger.debug("Debug message 3");
        this.assertEventCount(this.app.getEvents(), 2);
    }

    @Test
    public void debugChangeLevelAllChildrenLoggers() {
        this.logger.debug("Debug message 1");
        this.loggerChild.debug("Debug message 1 child");
        this.loggerGrandchild.debug("Debug message 1 grandchild");
        this.assertEventCount(this.app.getEvents(), 3);
        Configurator.setAllLevels((String)this.logger.getName(), (Level)Level.OFF);
        this.logger.debug("Debug message 2");
        this.loggerChild.warn("Warn message 2 child");
        this.loggerGrandchild.fatal("Fatal message 2 grandchild");
        this.assertEventCount(this.app.getEvents(), 3);
        Configurator.setAllLevels((String)this.logger.getName(), (Level)Level.DEBUG);
        this.logger.debug("Debug message 3");
        this.loggerChild.warn("Trace message 3 child");
        this.loggerGrandchild.trace("Fatal message 3 grandchild");
        this.assertEventCount(this.app.getEvents(), 5);
    }

    @Test
    public void debugChangeLevelChildLogger() {
        this.logger.debug("Debug message 1");
        this.loggerChild.debug("Debug message 1 child");
        this.loggerGrandchild.debug("Debug message 1 grandchild");
        this.assertEventCount(this.app.getEvents(), 3);
        Configurator.setLevel((String)this.logger.getName(), (Level)Level.OFF);
        this.logger.debug("Debug message 2");
        this.loggerChild.debug("Debug message 2 child");
        this.loggerGrandchild.debug("Debug message 2 grandchild");
        this.assertEventCount(this.app.getEvents(), 3);
        Configurator.setLevel((String)this.logger.getName(), (Level)Level.DEBUG);
        this.logger.debug("Debug message 3");
        this.loggerChild.debug("Debug message 3 child");
        this.loggerGrandchild.debug("Debug message 3 grandchild");
        this.assertEventCount(this.app.getEvents(), 6);
    }

    @Test
    public void debugChangeLevelsChildLoggers(LoggerContext context) {
        org.apache.logging.log4j.core.Logger loggerChild = context.getLogger(this.logger.getName() + ".child");
        this.logger.debug("Debug message 1");
        loggerChild.debug("Debug message 1 child");
        this.assertEventCount(this.app.getEvents(), 2);
        Configurator.setLevel((String)this.logger.getName(), (Level)Level.ERROR);
        Configurator.setLevel((String)loggerChild.getName(), (Level)Level.DEBUG);
        this.logger.debug("Debug message 2");
        loggerChild.debug("Debug message 2 child");
        this.assertEventCount(this.app.getEvents(), 3);
        Configurator.setLevel((String)this.logger.getName(), (Level)Level.DEBUG);
        this.logger.debug("Debug message 3");
        loggerChild.debug("Debug message 3 child");
        this.assertEventCount(this.app.getEvents(), 5);
    }

    @Test
    public void debugChangeLevelsMap() {
        this.logger.debug("Debug message 1");
        this.assertEventCount(this.app.getEvents(), 1);
        HashMap<String, Level> map = new HashMap<String, Level>();
        map.put(this.logger.getName(), Level.OFF);
        Configurator.setLevel(map);
        this.logger.debug("Debug message 2");
        this.assertEventCount(this.app.getEvents(), 1);
        map.put(this.logger.getName(), Level.DEBUG);
        Configurator.setLevel(map);
        this.logger.debug("Debug message 3");
        this.assertEventCount(this.app.getEvents(), 2);
    }

    @Test
    public void debugChangeLevelsMapChildLoggers() {
        this.logger.debug("Debug message 1");
        this.loggerChild.debug("Debug message 1 C");
        this.loggerGrandchild.debug("Debug message 1 GC");
        this.assertEventCount(this.app.getEvents(), 3);
        HashMap<String, Level> map = new HashMap<String, Level>();
        map.put(this.logger.getName(), Level.OFF);
        map.put(this.loggerChild.getName(), Level.DEBUG);
        map.put(this.loggerGrandchild.getName(), Level.WARN);
        Configurator.setLevel(map);
        this.logger.debug("Debug message 2");
        this.loggerChild.debug("Debug message 2 C");
        this.loggerGrandchild.debug("Debug message 2 GC");
        this.assertEventCount(this.app.getEvents(), 4);
        map.put(this.logger.getName(), Level.DEBUG);
        map.put(this.loggerChild.getName(), Level.OFF);
        map.put(this.loggerGrandchild.getName(), Level.DEBUG);
        Configurator.setLevel(map);
        this.logger.debug("Debug message 3");
        this.loggerChild.debug("Debug message 3 C");
        this.loggerGrandchild.debug("Debug message 3 GC");
        this.assertEventCount(this.app.getEvents(), 6);
    }

    @Test
    public void debugChangeRootLevel() {
        this.logger.debug("Debug message 1");
        this.assertEventCount(this.app.getEvents(), 1);
        Configurator.setRootLevel((Level)Level.OFF);
        this.logger.debug("Debug message 2");
        this.assertEventCount(this.app.getEvents(), 1);
        Configurator.setRootLevel((Level)Level.DEBUG);
        this.logger.debug("Debug message 3");
        this.assertEventCount(this.app.getEvents(), 2);
    }

    @Test
    public void getLogger_String_MessageFactoryMismatch(TestInfo testInfo) {
        org.apache.logging.log4j.core.Logger testLogger = LoggerTest.testMessageFactoryMismatch(testInfo.getTestMethod().map(Method::getName).orElseThrow(AssertionError::new), (MessageFactory)StringFormatterMessageFactory.INSTANCE, (MessageFactory)ParameterizedMessageFactory.INSTANCE);
        testLogger.debug("%,d", (Object)Integer.MAX_VALUE);
        List<LogEvent> events = this.app.getEvents();
        this.assertEventCount(events, 1);
        Assertions.assertEquals((Object)String.format("%,d", Integer.MAX_VALUE), (Object)events.get(0).getMessage().getFormattedMessage());
    }

    @Test
    public void getLogger_String_MessageFactoryMismatchNull(TestInfo testInfo) {
        org.apache.logging.log4j.core.Logger testLogger = LoggerTest.testMessageFactoryMismatch(testInfo.getTestMethod().map(Method::getName).orElseThrow(AssertionError::new), (MessageFactory)StringFormatterMessageFactory.INSTANCE, null);
        testLogger.debug("%,d", (Object)Integer.MAX_VALUE);
        List<LogEvent> events = this.app.getEvents();
        this.assertEventCount(events, 1);
        Assertions.assertEquals((Object)String.format("%,d", Integer.MAX_VALUE), (Object)events.get(0).getMessage().getFormattedMessage());
    }

    private static org.apache.logging.log4j.core.Logger testMessageFactoryMismatch(String name, MessageFactory messageFactory1, MessageFactory messageFactory2) {
        org.apache.logging.log4j.core.Logger testLogger1 = (org.apache.logging.log4j.core.Logger)LogManager.getLogger((String)name, (MessageFactory)messageFactory1);
        Assertions.assertNotNull((Object)testLogger1);
        LoggerTest.checkMessageFactory(messageFactory1, testLogger1);
        org.apache.logging.log4j.core.Logger testLogger2 = (org.apache.logging.log4j.core.Logger)LogManager.getLogger((String)name, (MessageFactory)messageFactory2);
        Assertions.assertNotNull((Object)testLogger2);
        LoggerTest.checkMessageFactory(messageFactory2, testLogger2);
        return testLogger1;
    }

    private static void checkMessageFactory(MessageFactory messageFactory1, org.apache.logging.log4j.core.Logger testLogger1) {
        if (messageFactory1 == null) {
            Assertions.assertEquals((Object)AbstractLogger.DEFAULT_MESSAGE_FACTORY_CLASS, testLogger1.getMessageFactory().getClass());
        } else {
            MessageFactory actual = testLogger1.getMessageFactory();
            if (actual instanceof MessageFactory2Adapter) {
                actual = ((MessageFactory2Adapter)actual).getOriginal();
            }
            Assertions.assertEquals((Object)messageFactory1, (Object)actual);
        }
    }

    @Test
    public void debugObject() {
        this.logger.debug((Object)new Date());
        List<LogEvent> events = this.app.getEvents();
        this.assertEventCount(events, 1);
    }

    @Test
    public void debugWithParms() {
        this.logger.debug("Hello, {}", (Object)"World");
        List<LogEvent> events = this.app.getEvents();
        this.assertEventCount(events, 1);
    }

    @Test
    public void testImpliedThrowable(LoggerContext context) {
        org.apache.logging.log4j.core.Logger testLogger = context.getLogger("org.apache.logging.log4j.hosttest");
        testLogger.debug("This is a test", new Throwable("Testing"));
        List<String> msgs = this.host.getMessages();
        Assertions.assertEquals((int)1, (int)msgs.size(), (String)("Incorrect number of messages. Expected 1, actual " + msgs.size()));
        String expected = "java.lang.Throwable: Testing";
        Assertions.assertTrue((boolean)msgs.get(0).contains("java.lang.Throwable: Testing"), (String)"Incorrect message data");
    }

    @Test
    public void testSuppressedThrowable(LoggerContext context) {
        org.apache.logging.log4j.core.Logger testLogger = context.getLogger("org.apache.logging.log4j.nothrown");
        testLogger.debug("This is a test", new Throwable("Testing"));
        List<String> msgs = this.noThrown.getMessages();
        Assertions.assertEquals((int)1, (int)msgs.size(), (String)("Incorrect number of messages. Expected 1, actual " + msgs.size()));
        String suppressed = "java.lang.Throwable: Testing";
        Assertions.assertFalse((boolean)msgs.get(0).contains("java.lang.Throwable: Testing"), (String)"Incorrect message data");
    }

    @Test
    public void mdc() {
        ThreadContext.put((String)"TestYear", (String)"2010");
        this.logger.debug("Debug message");
        ThreadContext.clearMap();
        this.logger.debug("Debug message");
        List<LogEvent> events = this.app.getEvents();
        this.assertEventCount(events, 2);
    }

    @Test
    public void structuredData() {
        ThreadContext.put((String)"loginId", (String)"JohnDoe");
        ThreadContext.put((String)"ipAddress", (String)"192.168.0.120");
        ThreadContext.put((String)"locale", (String)Locale.US.getDisplayName());
        StructuredDataMessage msg = new StructuredDataMessage("Audit@18060", "Transfer Complete", "Transfer");
        msg.put("ToAccount", "123456");
        msg.put("FromAccount", "123457");
        msg.put("Amount", "200.00");
        this.logger.info(MarkerManager.getMarker((String)"EVENT"), (Message)msg);
        ThreadContext.clearMap();
        List<LogEvent> events = this.app.getEvents();
        this.assertEventCount(events, 1);
    }

    @Test
    public void testReconfiguration(LoggerContext context) throws Exception {
        int i;
        Configuration oldConfig = context.getConfiguration();
        int MONITOR_INTERVAL_SECONDS = 5;
        File file = new File("target/test-classes/log4j-test2.xml");
        long orig = file.lastModified();
        long newTime = orig + 10000L;
        Assertions.assertTrue((boolean)file.setLastModified(newTime), (String)"setLastModified should have succeeded.");
        TimeUnit.SECONDS.sleep(6L);
        for (i = 0; i < 17; ++i) {
            this.logger.debug("Reconfigure");
        }
        Thread.sleep(100L);
        for (i = 0; i < 20 && context.getConfiguration() == oldConfig; ++i) {
            Thread.sleep(50L);
        }
        Configuration newConfig = context.getConfiguration();
        Assertions.assertNotNull((Object)newConfig, (String)"No configuration");
        Assertions.assertNotSame((Object)newConfig, (Object)oldConfig, (String)"Reconfiguration failed");
    }

    @Test
    public void testAdditivity(LoggerContext context) throws Exception {
        org.apache.logging.log4j.core.Logger localLogger = context.getLogger("org.apache.test");
        localLogger.error("Test parent additivity");
        List<LogEvent> events = this.app.getEvents();
        this.assertEventCount(events, 1);
    }

    @Test
    public void testLevelInheritance(LoggerContext context) throws Exception {
        Configuration config = context.getConfiguration();
        LoggerConfig loggerConfig = config.getLoggerConfig("org.apache.logging.log4j.core.LoggerTest");
        Assertions.assertNotNull((Object)loggerConfig);
        Assertions.assertEquals((Object)loggerConfig.getName(), (Object)"org.apache.logging.log4j.core.LoggerTest");
        Assertions.assertEquals((Object)loggerConfig.getLevel(), (Object)Level.DEBUG);
        org.apache.logging.log4j.core.Logger localLogger = context.getLogger("org.apache.logging.log4j.core.LoggerTest");
        Assertions.assertSame((Object)localLogger.getLevel(), (Object)Level.DEBUG, (String)("Incorrect level - expected DEBUG, actual " + localLogger.getLevel()));
    }

    @Test
    public void paramWithExceptionTest() throws Exception {
        this.logger.error("Throwing with parameters {}", (Object)"TestParam", (Object)new NullPointerException("Test Exception"));
        List<LogEvent> events = this.app.getEvents();
        Assertions.assertNotNull(events, (String)"Log event list not returned");
        Assertions.assertEquals((int)1, (int)events.size(), (String)"Incorrect number of log events");
        LogEvent event = events.get(0);
        Throwable thrown = event.getThrown();
        Assertions.assertNotNull((Object)thrown, (String)"No throwable present in log event");
        Message msg = event.getMessage();
        Assertions.assertEquals((Object)"Throwing with parameters {}", (Object)msg.getFormat());
        Assertions.assertEquals((Object)"Throwing with parameters TestParam", (Object)msg.getFormattedMessage());
        Assertions.assertArrayEquals((Object[])new Object[]{"TestParam", thrown}, (Object[])msg.getParameters());
    }
}

