/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core;

import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.junit.LoggerContextSource;
import org.apache.logging.log4j.junit.Named;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ObjectMessage;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@LoggerContextSource(value="log4j-Level.xml")
public class LevelTest {
    private final ListAppender listAll;
    private final ListAppender listTrace;
    private final ListAppender listDebug;
    private final ListAppender listInfo;
    private final ListAppender listWarn;
    private final ListAppender listError;
    private final ListAppender listFatal;

    public LevelTest(@Named(value="ListAll") ListAppender listAll, @Named(value="ListTrace") ListAppender listTrace, @Named(value="ListDebug") ListAppender listDebug, @Named(value="ListInfo") ListAppender listInfo, @Named(value="ListWarn") ListAppender listWarn, @Named(value="ListError") ListAppender listError, @Named(value="ListFatal") ListAppender listFatal) {
        this.listAll = listAll.clear();
        this.listTrace = listTrace.clear();
        this.listDebug = listDebug.clear();
        this.listInfo = listInfo.clear();
        this.listWarn = listWarn.clear();
        this.listError = listError.clear();
        this.listFatal = listFatal.clear();
    }

    @Test
    public void testLevelLogging(LoggerContext context) {
        Expected[] expectedResults;
        Marker marker = MarkerManager.getMarker((String)"marker");
        ObjectMessage msg = new ObjectMessage((Object)"msg");
        Throwable t = new Throwable("test");
        Level[] levels = new Level[]{Level.TRACE, Level.DEBUG, Level.INFO, Level.WARN, Level.ERROR, Level.FATAL};
        String[] names = new String[]{"levelTest", "levelTest.Trace", "levelTest.Debug", "levelTest.Info", "levelTest.Warn", "levelTest.Error", "levelTest.Fatal"};
        for (Level level : levels) {
            String[] stringArray = names;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String name = stringArray[i];
                Logger logger = context.getLogger(name);
                logger.log(level, (Message)msg);
                logger.log(level, (Object)123);
                logger.log(level, name);
                logger.log(level, marker, (Message)msg);
                logger.log(level, marker, (Object)123);
                logger.log(level, marker, name);
                logger.log(level, (Message)msg, t);
                logger.log(level, (Object)123, t);
                logger.log(level, name, (Object)"param1", (Object)"param2");
                logger.log(level, name, t);
                logger.log(level, marker, (Message)msg, t);
                logger.log(level, marker, (Object)123, t);
                logger.log(level, marker, name, (Object)"param1", (Object)"param2");
                logger.log(level, marker, name, t);
            }
        }
        int levelCount = names.length - 1;
        int UNIT = 14;
        for (Expected expected : expectedResults = new Expected[]{new Expected(this.listAll, 14 * levelCount, "TRACE", "All"), new Expected(this.listTrace, 14 * levelCount--, "TRACE", "Trace"), new Expected(this.listDebug, 14 * levelCount--, "DEBUG", "Debug"), new Expected(this.listInfo, 14 * levelCount--, "INFO", "Info"), new Expected(this.listWarn, 14 * levelCount--, "WARN", "Warn"), new Expected(this.listError, 14 * levelCount--, "ERROR", "Error"), new Expected(this.listFatal, 14 * levelCount--, "FATAL", "Fatal")}) {
            String description = expected.description;
            List<LogEvent> events = expected.appender.getEvents();
            Assertions.assertNotNull(events, (String)(description + ": No events"));
            MatcherAssert.assertThat(events, (Matcher)Matchers.hasSize((int)expected.expectedEventCount));
            LogEvent event = events.get(0);
            Assertions.assertEquals((Object)event.getLevel().name(), (Object)expected.expectedInitialEventLevel, (String)(description + ": Expected level " + expected.expectedInitialEventLevel + ", got" + event.getLevel()));
        }
    }

    private static class Expected {
        final ListAppender appender;
        final int expectedEventCount;
        final String expectedInitialEventLevel;
        final String description;

        Expected(ListAppender appender, int expectedCount, String level, String description) {
            this.appender = appender;
            this.expectedEventCount = expectedCount;
            this.expectedInitialEventLevel = level;
            this.description = description;
        }
    }
}

